/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.socket_mode;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.slack.api.Slack;
import com.slack.api.socket_mode.listener.EnvelopeListener;
import com.slack.api.socket_mode.listener.WebSocketCloseListener;
import com.slack.api.socket_mode.listener.WebSocketErrorListener;
import com.slack.api.socket_mode.listener.WebSocketMessageListener;
import com.slack.api.socket_mode.queue.SocketModeMessageQueue;
import com.slack.api.socket_mode.request.EventsApiEnvelope;
import com.slack.api.socket_mode.request.InteractiveEnvelope;
import com.slack.api.socket_mode.request.SlashCommandsEnvelope;
import com.slack.api.socket_mode.response.SocketModeResponse;
import com.slack.api.util.json.GsonFactory;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SocketModeClient
extends Closeable {
    public static final int DEFAULT_MESSAGE_PROCESSOR_CONCURRENCY = 10;
    public static final long DEFAULT_SESSION_MONITOR_INTERVAL_MILLISECONDS = 5000L;
    public static final Logger LOGGER = LoggerFactory.getLogger(SocketModeClient.class);
    public static final Gson GSON = GsonFactory.createSnakeCase();
    public static final Gson PRETTY_PRINTING = new GsonBuilder().setPrettyPrinting().create();
    public static final String EXECUTOR_GROUP_NAME_PREFIX = "socket-mode";

    public void connect() throws IOException;

    public boolean verifyConnection();

    public boolean isAutoReconnectOnCloseEnabled();

    public void setAutoReconnectOnCloseEnabled(boolean var1);

    default public void connectToNewEndpoint() throws IOException {
        try {
            this.setWssUri(new URI(this.getSlack().issueSocketModeUrl(this.getAppToken())));
            this.connect();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public void disconnect() throws IOException;

    @Override
    default public void close() throws IOException {
        List<Runnable> neverCommencedExecutions;
        this.setAutoReconnectEnabled(false);
        this.disconnect();
        for (Runnable neverCommencedExecution : this.getMessageProcessorExecutor().shutdownNow()) {
            neverCommencedExecution.run();
        }
        if (this.getSessionMonitorExecutor().isPresent() && (neverCommencedExecutions = this.getSessionMonitorExecutor().get().shutdownNow()) != null && neverCommencedExecutions.size() > 0) {
            this.getLogger().info("This client is going to be terminated. {} executions in SessionStateMonitorExecutor did not begin.", (Object)neverCommencedExecutions.size());
        }
    }

    public Slack getSlack();

    public void setSlack(Slack var1);

    public String getAppToken();

    public void setAppToken(String var1);

    public URI getWssUri();

    public void setWssUri(URI var1);

    public boolean isAutoReconnectEnabled();

    public void setAutoReconnectEnabled(boolean var1);

    public boolean isSessionMonitorEnabled();

    public void setSessionMonitorEnabled(boolean var1);

    public Optional<ScheduledExecutorService> getSessionMonitorExecutor();

    public void setSessionMonitorExecutor(Optional<ScheduledExecutorService> var1);

    public SocketModeMessageQueue getMessageQueue();

    public void setMessageQueue(SocketModeMessageQueue var1);

    public ScheduledExecutorService getMessageProcessorExecutor();

    public void setMessageProcessorExecutor(ScheduledExecutorService var1);

    default public void initializeMessageProcessorExecutor(int concurrency) {
        String processorName = this.getExecutorGroupNamePrefix() + "-message-processor";
        ScheduledExecutorService messageProcessorExecutor = this.getSlack().getConfig().getExecutorServiceProvider().createThreadScheduledExecutor(processorName);
        int i = 0;
        while (i < concurrency) {
            int num = i++;
            messageProcessorExecutor.scheduleAtFixedRate(() -> {
                try {
                    String message = this.getMessageQueue().poll();
                    if (message != null) {
                        this.processMessage(message);
                    }
                }
                catch (Exception e) {
                    this.getLogger().error("Failed to poll a message or run processMessage (error: {})", (Object)e.getMessage(), (Object)e);
                }
            }, 0L, 10L, TimeUnit.MILLISECONDS);
        }
        this.setMessageProcessorExecutor(messageProcessorExecutor);
    }

    default public void initializeSessionMonitorExecutor(long intervalMillis) {
        if (this.isSessionMonitorEnabled()) {
            String groupName = this.getExecutorGroupNamePrefix() + "-session-monitor";
            ScheduledExecutorService executorService = this.getSlack().getConfig().getExecutorServiceProvider().createThreadScheduledExecutor(groupName);
            AtomicLong nextInvocationMillis = new AtomicLong(System.currentTimeMillis());
            executorService.scheduleWithFixedDelay(() -> {
                long startMillis = System.currentTimeMillis();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Checking the current session...");
                }
                if (this.isAutoReconnectEnabled() && nextInvocationMillis.get() <= System.currentTimeMillis()) {
                    nextInvocationMillis.set(this.maintainCurrentSession());
                }
                if (this.getLogger().isDebugEnabled()) {
                    long spentMillis = System.currentTimeMillis() - startMillis;
                    this.getLogger().debug("The session maintenance completed in {} milliseconds", (Object)spentMillis);
                }
            }, 5000L, intervalMillis, TimeUnit.MILLISECONDS);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("SessionStateMonitorExecutor started.");
            }
            this.setSessionMonitorExecutor(Optional.of(executorService));
        } else {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("SessionStateMonitorExecutor is disabled.");
            }
            this.setSessionMonitorExecutor(Optional.empty());
        }
    }

    default public void sendSocketModeResponse(SocketModeResponse response) {
        this.sendSocketModeResponse(this.getGson().toJson(response));
    }

    default public void sendSocketModeResponse(String message) {
        this.debugLogResponse(message);
        this.sendWebSocketMessage(message);
    }

    public void sendWebSocketMessage(String var1);

    public List<WebSocketErrorListener> getWebSocketErrorListeners();

    default public void addWebSocketErrorListener(WebSocketErrorListener listener) {
        this.getWebSocketErrorListeners().add(listener);
    }

    default public void removeWebSocketErrorListener(WebSocketErrorListener listener) {
        this.getWebSocketErrorListeners().remove(listener);
    }

    default public void runErrorListeners(Throwable reason) {
        for (WebSocketErrorListener listener : this.getWebSocketErrorListeners()) {
            listener.handle(reason);
        }
    }

    public List<WebSocketCloseListener> getWebSocketCloseListeners();

    default public void addWebSocketCloseListener(WebSocketCloseListener listener) {
        this.getWebSocketCloseListeners().add(listener);
    }

    default public void removeWebSocketCloseListener(WebSocketCloseListener listener) {
        this.getWebSocketCloseListeners().remove(listener);
    }

    default public void runCloseListenersAndAutoReconnectAsNecessary(Integer code, String reason) {
        for (WebSocketCloseListener listener : this.getWebSocketCloseListeners()) {
            listener.handle(code, reason);
        }
        if (this.isAutoReconnectOnCloseEnabled() && this.isAutoReconnectEnabled() && !this.verifyConnection()) {
            try {
                this.connectToNewEndpoint();
            }
            catch (IOException e) {
                this.getLogger().error("Failed to reconnect to the Socket Mode server: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    default public void enqueueMessage(String message) {
        this.debugLogRequest(message);
        if (message.startsWith("{")) {
            this.getMessageQueue().add(message);
        }
    }

    public List<WebSocketMessageListener> getWebSocketMessageListeners();

    default public void addWebSocketMessageListener(WebSocketMessageListener listener) {
        this.getWebSocketMessageListeners().add(listener);
    }

    default public void removeWebSocketMessageListener(WebSocketMessageListener listener) {
        this.getWebSocketMessageListeners().remove(listener);
    }

    public List<EnvelopeListener<EventsApiEnvelope>> getEventsApiEnvelopeListeners();

    public List<EnvelopeListener<InteractiveEnvelope>> getInteractiveEnvelopeListeners();

    public List<EnvelopeListener<SlashCommandsEnvelope>> getSlashCommandsEnvelopeListeners();

    default public void addEventsApiEnvelopeListener(EnvelopeListener<EventsApiEnvelope> listener) {
        this.getEventsApiEnvelopeListeners().add(listener);
    }

    default public void removeEventsApiEnvelopeListener(EnvelopeListener<EventsApiEnvelope> listener) {
        this.getEventsApiEnvelopeListeners().remove(listener);
    }

    default public void addInteractiveEnvelopeListener(EnvelopeListener<InteractiveEnvelope> listener) {
        this.getInteractiveEnvelopeListeners().add(listener);
    }

    default public void removeInteractiveEnvelopeListener(EnvelopeListener<InteractiveEnvelope> listener) {
        this.getInteractiveEnvelopeListeners().remove(listener);
    }

    default public void addSlashCommandsEnvelopeListener(EnvelopeListener<SlashCommandsEnvelope> listener) {
        this.getSlashCommandsEnvelopeListeners().add(listener);
    }

    default public void removeSlashCommandsEnvelopeListener(EnvelopeListener<SlashCommandsEnvelope> listener) {
        this.getSlashCommandsEnvelopeListeners().remove(listener);
    }

    default public Logger getLogger() {
        return LOGGER;
    }

    default public Gson getGson() {
        return GSON;
    }

    default public void processMessage(String message) throws IOException {
        if (!message.startsWith("{")) {
            return;
        }
        Gson gson = this.getGson();
        JsonElement messageObj = gson.fromJson(message, JsonElement.class);
        if (!messageObj.isJsonObject()) {
            return;
        }
        JsonObject messageJson = messageObj.getAsJsonObject();
        JsonElement typeJson = messageJson.get("type");
        if (typeJson == null || typeJson.isJsonNull()) {
            return;
        }
        String type = typeJson.getAsString();
        if ("disconnect".equals(type)) {
            this.connectToNewEndpoint();
            return;
        }
        for (WebSocketMessageListener webSocketMessageListener : this.getWebSocketMessageListeners()) {
            webSocketMessageListener.handle(message);
        }
        if (type.equals("events_api")) {
            for (EnvelopeListener envelopeListener : this.getEventsApiEnvelopeListeners()) {
                envelopeListener.handle(gson.fromJson(message, EventsApiEnvelope.class));
            }
        }
        if (type.equals("interactive")) {
            for (EnvelopeListener envelopeListener : this.getInteractiveEnvelopeListeners()) {
                envelopeListener.handle(gson.fromJson(message, InteractiveEnvelope.class));
            }
        }
        if (type.equals("slash_commands")) {
            for (EnvelopeListener envelopeListener : this.getSlashCommandsEnvelopeListeners()) {
                envelopeListener.handle(gson.fromJson(message, SlashCommandsEnvelope.class));
            }
        }
    }

    default public void debugLogRequest(String message) {
        if (this.getLogger().isDebugEnabled() && message != null) {
            if (message.startsWith("{")) {
                JsonElement json = this.getGson().fromJson(message, JsonElement.class);
                this.getLogger().debug("Socket Mode Request:\n\n{}\n", (Object)PRETTY_PRINTING.toJson(json));
            } else {
                this.getLogger().debug("Socket Mode Request:\n\n{}\n", (Object)message);
            }
        }
    }

    default public void debugLogResponse(String message) {
        if (this.getLogger().isDebugEnabled()) {
            if (message.startsWith("{")) {
                JsonElement json = this.getGson().fromJson(message, JsonElement.class);
                this.getLogger().debug("Socket Mode Response:\n\n{}\n", (Object)PRETTY_PRINTING.toJson(json));
            } else {
                this.getLogger().debug("Socket Mode Response:\n\n{}\n", (Object)message);
            }
        }
    }

    default public String getExecutorGroupNamePrefix() {
        return EXECUTOR_GROUP_NAME_PREFIX;
    }

    public long maintainCurrentSession();

    public static enum Backend {
        Tyrus,
        JavaWebSocket;

    }
}

