/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import com.slack.api.model.admin.AppWorkflow;
import com.slack.api.util.json.GsonFactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonAppWorkflowStepInputValueDefaultFactory
implements JsonDeserializer<AppWorkflow.StepInputValueElementDefault>,
JsonSerializer<AppWorkflow.StepInputValueElementDefault> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GsonAppWorkflowStepInputValueDefaultFactory.class);
    private static final String REPORT_THIS = "Please report this issue at https://github.com/slackapi/java-slack-sdk/issues";
    private final boolean failOnUnknownProperties;
    private static final Gson GSON = GsonFactory.createSnakeCase();
    private static final Type TYPE = new TypeToken<List<String>>(){}.getType();

    public GsonAppWorkflowStepInputValueDefaultFactory() {
        this(false);
    }

    public GsonAppWorkflowStepInputValueDefaultFactory(boolean failOnUnknownProperties) {
        this.failOnUnknownProperties = failOnUnknownProperties;
    }

    @Override
    public AppWorkflow.StepInputValueElementDefault deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        AppWorkflow.StepInputValueElementDefault result = new AppWorkflow.StepInputValueElementDefault();
        if (json.isJsonPrimitive()) {
            result.setStringValue(json.getAsString());
            return result;
        }
        if (json.isJsonArray()) {
            ArrayList<String> values2 = new ArrayList<String>();
            for (JsonElement j : json.getAsJsonArray()) {
                values2.add(j.getAsString());
            }
            result.setStringValues(values2);
            return result;
        }
        if (this.failOnUnknownProperties) {
            String message = "The whole value (" + json + ") is unsupported. " + REPORT_THIS;
            throw new JsonParseException(message);
        }
        return result;
    }

    private List<String> parseRequired(JsonElement json) throws JsonParseException {
        ArrayList<String> values2 = new ArrayList<String>();
        for (JsonElement elem : json.getAsJsonArray()) {
            if (elem.isJsonPrimitive()) {
                values2.add(elem.getAsString());
                continue;
            }
            if (!this.failOnUnknownProperties) continue;
            String message = "An unexpected element (" + elem + ") in an array is detected. " + REPORT_THIS;
            throw new JsonParseException(message);
        }
        return values2;
    }

    @Override
    public JsonElement serialize(AppWorkflow.StepInputValueElementDefault src, Type typeOfSrc, JsonSerializationContext context) {
        if (src.getStringValues() != null) {
            JsonArray array = new JsonArray();
            for (String value : src.getStringValues()) {
                array.add(GSON.toJson(value));
            }
            return array;
        }
        if (src.getStringValue() != null) {
            return new JsonPrimitive(src.getStringValue());
        }
        return JsonNull.INSTANCE;
    }
}

