/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.slack.api.audit.response.LogsResponse;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonAuditLogsDetailsChangedValueFactory
implements JsonDeserializer<LogsResponse.DetailsChangedValue>,
JsonSerializer<LogsResponse.DetailsChangedValue> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GsonAuditLogsDetailsChangedValueFactory.class);
    private static final String REPORT_THIS = "Please report this issue at https://github.com/slackapi/java-slack-sdk/issues";
    private final boolean failOnUnknownProperties;

    public GsonAuditLogsDetailsChangedValueFactory() {
        this(false);
    }

    public GsonAuditLogsDetailsChangedValueFactory(boolean failOnUnknownProperties) {
        this.failOnUnknownProperties = failOnUnknownProperties;
    }

    @Override
    public LogsResponse.DetailsChangedValue deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        LogsResponse.DetailsChangedValue result = new LogsResponse.DetailsChangedValue();
        if (json.isJsonPrimitive()) {
            result.setStringValue(json.getAsString());
            return result;
        }
        if (json.isJsonArray()) {
            result.setStringValues(this.parseStringArray(json));
            return result;
        }
        if (json.isJsonObject()) {
            HashMap<String, List<String>> namedValues = new HashMap<String, List<String>>();
            result.setNamedStringValues(namedValues);
            JsonObject obj = json.getAsJsonObject();
            for (String name : obj.keySet()) {
                JsonElement value = obj.get(name);
                if (value.isJsonArray()) {
                    namedValues.put(name, this.parseStringArray(value));
                    continue;
                }
                if (!this.failOnUnknownProperties) continue;
                String message = "A non-array value (" + value + ") for " + name + " is detected. " + REPORT_THIS;
                throw new JsonParseException(message);
            }
            return result;
        }
        if (this.failOnUnknownProperties) {
            String message = "The whole value (" + json + ") is unsupported. " + REPORT_THIS;
            throw new JsonParseException(message);
        }
        return result;
    }

    private List<String> parseStringArray(JsonElement json) throws JsonParseException {
        ArrayList<String> values2 = new ArrayList<String>();
        for (JsonElement elem : json.getAsJsonArray()) {
            if (elem.isJsonPrimitive()) {
                values2.add(elem.getAsString());
                continue;
            }
            if (!this.failOnUnknownProperties) continue;
            String message = "An unexpected element (" + elem + ") in an array is detected. " + REPORT_THIS;
            throw new JsonParseException(message);
        }
        return values2;
    }

    @Override
    public JsonElement serialize(LogsResponse.DetailsChangedValue src, Type typeOfSrc, JsonSerializationContext context) {
        if (src.getStringValue() != null) {
            return new JsonPrimitive(src.getStringValue());
        }
        if (src.getStringValues() != null) {
            JsonArray array = new JsonArray();
            for (String value : src.getStringValues()) {
                array.add(value);
            }
            return array;
        }
        if (src.getNamedStringValues() != null) {
            JsonObject json = new JsonObject();
            for (Map.Entry<String, List<String>> each : src.getNamedStringValues().entrySet()) {
                JsonArray array = new JsonArray();
                for (String value : each.getValue()) {
                    array.add(value);
                }
                json.add(each.getKey(), array);
            }
            return json;
        }
        log.warn("Unsupported field in LogsResponse.DetailsChangedValue is detected ({})", (Object)src);
        return JsonNull.INSTANCE;
    }
}

