/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.slack.api.model.event.FunctionExecutedEvent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class GsonFunctionExecutedEventInputValueFactory
implements JsonDeserializer<FunctionExecutedEvent.InputValue>,
JsonSerializer<FunctionExecutedEvent.InputValue> {
    private static final String REPORT_THIS = "Please report this issue at https://github.com/slackapi/java-slack-sdk/issues";
    private final boolean failOnUnknownProperties;

    public GsonFunctionExecutedEventInputValueFactory() {
        this(false);
    }

    public GsonFunctionExecutedEventInputValueFactory(boolean failOnUnknownProperties) {
        this.failOnUnknownProperties = failOnUnknownProperties;
    }

    @Override
    public FunctionExecutedEvent.InputValue deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        FunctionExecutedEvent.InputValue result = new FunctionExecutedEvent.InputValue();
        if (json.isJsonPrimitive()) {
            result.setStringValue(json.getAsString());
            return result;
        }
        if (json.isJsonArray()) {
            result.setStringValues(this.parseStringArray(json));
            return result;
        }
        if (this.failOnUnknownProperties) {
            String message = "The whole value (" + json + ") is unsupported. " + REPORT_THIS;
            throw new JsonParseException(message);
        }
        return result;
    }

    private List<String> parseStringArray(JsonElement json) throws JsonParseException {
        ArrayList<String> values2 = new ArrayList<String>();
        for (JsonElement elem : json.getAsJsonArray()) {
            if (elem.isJsonPrimitive()) {
                values2.add(elem.getAsString());
                continue;
            }
            if (!this.failOnUnknownProperties) continue;
            String message = "An unexpected element (" + elem + ") in an array is detected. " + REPORT_THIS;
            throw new JsonParseException(message);
        }
        return values2;
    }

    @Override
    public JsonElement serialize(FunctionExecutedEvent.InputValue src, Type typeOfSrc, JsonSerializationContext context) {
        if (src.getStringValue() != null) {
            return new JsonPrimitive(src.getStringValue());
        }
        if (src.getStringValues() != null) {
            JsonArray array = new JsonArray();
            for (String value : src.getStringValues()) {
                array.add(value);
            }
            return array;
        }
        return JsonNull.INSTANCE;
    }
}

