/*
 * Decompiled with CFR 0.152.
 */
package com.hierynomus.smbj.io;

import com.hierynomus.smbj.common.SMBRuntimeException;
import com.hierynomus.smbj.io.CachingByteChunkProvider;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamByteChunkProvider
extends CachingByteChunkProvider {
    private BufferedInputStream is;
    private boolean close;

    public InputStreamByteChunkProvider(InputStream is) {
        if (is instanceof BufferedInputStream) {
            this.is = (BufferedInputStream)is;
        } else {
            this.is = new BufferedInputStream(is);
            this.close = true;
        }
    }

    @Override
    int prepareChunk(byte[] chunk, int bytesNeeded) throws IOException {
        int toRead = Math.min(bytesNeeded, chunk.length);
        if (toRead == 0) {
            return -1;
        }
        return this.is.read(chunk, 0, toRead);
    }

    @Override
    public boolean isAvailable() {
        try {
            return super.isAvailable() || this.is != null && this.is.available() > 0;
        }
        catch (IOException e) {
            throw new SMBRuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.is != null && this.close) {
            try {
                this.is.close();
            }
            finally {
                this.is = null;
            }
        }
    }
}

