/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smb;

import com.hierynomus.msfscc.fileinformation.FileIdBothDirectoryInformation;
import com.hierynomus.smbj.SMBClient;
import com.hierynomus.smbj.auth.AuthenticationContext;
import com.hierynomus.smbj.connection.Connection;
import com.hierynomus.smbj.session.Session;
import com.hierynomus.smbj.share.DiskShare;
import com.hierynomus.smbj.share.File;
import java.io.Closeable;
import java.io.IOException;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.smb.SmbConfiguration;
import org.apache.camel.component.smb.SmbEndpoint;
import org.apache.camel.component.smb.SmbIOBean;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.support.ScheduledPollConsumer;
import org.apache.camel.util.IOHelper;

public class SmbConsumer
extends ScheduledPollConsumer {
    private final SmbEndpoint endpoint;
    private final SmbConfiguration configuration;
    private final SMBClient smbClient;
    private Connection connection;
    private Session session;
    private DiskShare share;

    public SmbConsumer(SmbEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
        this.configuration = endpoint.getConfiguration();
        this.smbClient = this.configuration.getSmbConfig() != null ? new SMBClient(this.configuration.getSmbConfig()) : new SMBClient();
    }

    private int pollDirectory(DiskShare share, SmbConfiguration configuration, int polledCount, String path) throws Exception {
        SmbIOBean smbIOBean = configuration.getSmbIoBean();
        String searchPattern = configuration.getSearchPattern();
        IdempotentRepository repository = configuration.getIdempotentRepository();
        path = path == null ? "" : path;
        for (FileIdBothDirectoryInformation f : share.list(path, searchPattern)) {
            if (f.getFileName().equals(".") || f.getFileName().equals("..")) continue;
            String fullFilePath = "";
            if (!"".equals(path)) {
                fullFilePath = new String(path + java.io.File.separator + f.getFileName());
            }
            if (share.folderExists(fullFilePath)) {
                if (!configuration.isRecursive()) continue;
                polledCount = this.pollDirectory(share, configuration, polledCount, new String(fullFilePath));
                continue;
            }
            if (repository.contains(fullFilePath)) continue;
            ++polledCount;
            Exchange exchange = this.createExchange(true);
            File file = share.openFile(fullFilePath, smbIOBean.accessMask(), smbIOBean.attributes(), smbIOBean.shareAccesses(), smbIOBean.createDisposition(), smbIOBean.createOptions());
            repository.add(fullFilePath);
            exchange.getMessage().setHeader("CamelSmbFilePath", file.getPath());
            exchange.getMessage().setHeader("CamelSmbUncPath", file.getUncPath());
            exchange.getMessage().setHeader("CamelFileName", file.getFileInformation().getNameInformation().toString());
            exchange.getMessage().setBody(file);
            try {
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                exchange.setException(e);
            }
            if (exchange.getException() == null) continue;
            Exception e = exchange.getException();
            String msg = "Error processing file " + fullFilePath + " due to " + e.getMessage();
            this.handleException(msg, exchange, e);
        }
        return polledCount;
    }

    @Override
    protected int poll() throws Exception {
        int polledCount = 0;
        polledCount = this.pollDirectory(this.share, this.configuration, polledCount, this.configuration.getPath());
        return polledCount;
    }

    private void refreshConnection() throws IOException {
        if (this.connection != null && this.connection.isConnected()) {
            return;
        }
        this.connection = this.smbClient.connect(this.endpoint.getHostname(), this.endpoint.getPort());
        AuthenticationContext ac = new AuthenticationContext(this.configuration.getUsername(), this.configuration.getPassword().toCharArray(), this.configuration.getDomain());
        this.session = this.connection.authenticate(ac);
        this.share = (DiskShare)this.session.connectShare(this.endpoint.getShareName());
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.refreshConnection();
    }

    @Override
    protected void doStop() throws Exception {
        if (this.connection != null) {
            IOHelper.close((Closeable)this.connection);
        }
        super.doStop();
    }
}

