/*
 * Decompiled with CFR 0.152.
 */
package org.smooks;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.ThreadSafe;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.FilterSettings;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ExecutionContext;
import org.smooks.api.Registry;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.bean.context.BeanContext;
import org.smooks.api.bean.lifecycle.BeanContextLifecycleObserver;
import org.smooks.api.delivery.ContentDeliveryConfig;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.Filter;
import org.smooks.api.delivery.FilterBypass;
import org.smooks.api.delivery.VisitorAppender;
import org.smooks.api.lifecycle.FilterLifecycle;
import org.smooks.api.lifecycle.LifecycleManager;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.profile.Profile;
import org.smooks.api.profile.UnknownProfileMemberException;
import org.smooks.api.resource.config.ReaderConfigurator;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.assertion.AssertArgument;
import org.smooks.classpath.CascadingClassLoaderSet;
import org.smooks.engine.DefaultApplicationContextBuilder;
import org.smooks.engine.DefaultExecutionContext;
import org.smooks.engine.bean.context.preinstalled.Time;
import org.smooks.engine.bean.context.preinstalled.UniqueID;
import org.smooks.engine.delivery.DefaultContentHandlerBinding;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lifecycle.PostFilterLifecyclePhase;
import org.smooks.engine.lifecycle.PreFilterLifecyclePhase;
import org.smooks.engine.lookup.InstanceLookup;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.smooks.engine.xml.NamespaceManager;
import org.smooks.io.payload.Exports;
import org.smooks.io.payload.FilterResult;
import org.smooks.io.payload.FilterSource;
import org.smooks.io.payload.JavaResult;
import org.smooks.resource.URIResourceLocator;
import org.smooks.support.URIUtil;
import org.xml.sax.SAXException;

@ThreadSafe
public class Smooks
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Smooks.class);
    private final ApplicationContext applicationContext;
    private final List<ContentHandlerBinding<Visitor>> visitorBindings;
    private final LifecycleManager lifecycleManager;
    private final Registry registry;
    private volatile boolean isConfigurable = true;

    public Smooks() {
        this(new DefaultApplicationContextBuilder().build());
    }

    public Smooks(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.visitorBindings = new ArrayList<ContentHandlerBinding<Visitor>>();
        this.registry = applicationContext.getRegistry();
        this.lifecycleManager = this.registry.lookup(new LifecycleManagerLookup());
    }

    public Smooks(String resourceURI) throws IOException, SAXException {
        URIResourceLocator resourceLocator = new URIResourceLocator();
        resourceLocator.setBaseURI(URIResourceLocator.extractBaseURI(resourceURI));
        this.applicationContext = new DefaultApplicationContextBuilder().withResourceLocator(resourceLocator).build();
        this.registry = this.applicationContext.getRegistry();
        this.lifecycleManager = this.registry.lookup(new LifecycleManagerLookup());
        this.visitorBindings = new ArrayList<ContentHandlerBinding<Visitor>>();
        this.addResourceConfigs(resourceURI);
    }

    public Smooks(InputStream inputStream) throws IOException, SAXException {
        this();
        this.addResourceConfigs(inputStream);
    }

    public void setFilterSettings(FilterSettings filterSettings) {
        AssertArgument.isNotNull(filterSettings, "filterSettings");
        filterSettings.applySettings(this);
    }

    public Smooks setExports(Exports exports) {
        AssertArgument.isNotNull(exports, "exports");
        this.applicationContext.getRegistry().deRegisterObject(Exports.class);
        this.applicationContext.getRegistry().registerObject(Exports.class, exports);
        return this;
    }

    public void setReaderConfig(ReaderConfigurator readerConfigurator) {
        List<ResourceConfig> resourceConfigs = readerConfigurator.toConfig();
        for (ResourceConfig resourceConfig : resourceConfigs) {
            this.addResourceConfig(resourceConfig);
        }
    }

    public void setNamespaces(Properties namespaces) {
        AssertArgument.isNotNull(namespaces, "namespaces");
        this.assertIsConfigurable();
        this.applicationContext.getRegistry().registerObject(NamespaceManager.class, namespaces);
    }

    public ResourceConfig addVisitor(Visitor visitor) {
        return this.addVisitor(visitor, "#document");
    }

    public ResourceConfig addVisitor(Visitor visitor, String targetSelector) {
        this.assertIsConfigurable();
        AssertArgument.isNotNull(visitor, "visitor");
        AssertArgument.isNotNull(targetSelector, "targetSelector");
        DefaultContentHandlerBinding<Visitor> contentHandlerBinding = new DefaultContentHandlerBinding<Visitor>(visitor, targetSelector, this.applicationContext.getRegistry());
        this.visitorBindings.add(contentHandlerBinding);
        return contentHandlerBinding.getResourceConfig();
    }

    public void addVisitors(VisitorAppender visitorAppender) {
        this.getApplicationContext().getRegistry().lookup(new LifecycleManagerLookup()).applyPhase(visitorAppender, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this.applicationContext.getRegistry())));
        for (ContentHandlerBinding<Visitor> visitorBinding : visitorAppender.addVisitors()) {
            this.getApplicationContext().getRegistry().lookup(new LifecycleManagerLookup()).applyPhase(visitorBinding.getContentHandler(), (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this.applicationContext.getRegistry(), visitorBinding.getResourceConfig(), visitorBinding.getContentHandler())));
            this.visitorBindings.add(visitorBinding);
        }
    }

    public void addResourceConfig(ResourceConfig resourceConfig) {
        AssertArgument.isNotNull(resourceConfig, "resourceConfig");
        this.assertIsConfigurable();
        this.applicationContext.getRegistry().registerResourceConfig(resourceConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceConfigs(String resourceURI) throws IOException, SAXException {
        AssertArgument.isNotNullAndNotEmpty(resourceURI, "resourceURI");
        URIResourceLocator resourceLocator = new URIResourceLocator();
        try (InputStream resourceConfigStream = resourceLocator.getResource(resourceURI);){
            URI resourceConfigsURI = new URI(resourceURI);
            this.addResourceConfigs(URIUtil.getParent(resourceConfigsURI).toString(), resourceConfigStream);
        }
    }

    public void addResourceConfigs(String baseURI, InputStream inputStream) throws SAXException, IOException {
        this.assertIsConfigurable();
        AssertArgument.isNotNullAndNotEmpty(baseURI, "baseURI");
        AssertArgument.isNotNull(inputStream, "inputStream");
        try {
            this.applicationContext.getRegistry().registerResources(baseURI, inputStream);
        }
        catch (URISyntaxException e) {
            throw new SmooksConfigException("Failed to read resource configuration. Invalid 'baseURI'.");
        }
    }

    public void addResourceConfigs(InputStream resourceConfigStream) throws SAXException, IOException {
        this.addResourceConfigs("./", resourceConfigStream);
    }

    public ExecutionContext createExecutionContext() {
        return this.createExecutionContext(Profile.DEFAULT_PROFILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionContext createExecutionContext(String targetProfile) throws UnknownProfileMemberException {
        if (this.applicationContext.getClassLoader() != null) {
            ClassLoader originalTCCL = Thread.currentThread().getContextClassLoader();
            CascadingClassLoaderSet newTCCL = new CascadingClassLoaderSet();
            newTCCL.addClassLoader(this.applicationContext.getClassLoader());
            newTCCL.addClassLoader(originalTCCL);
            Thread.currentThread().setContextClassLoader(newTCCL);
            try {
                if (this.isConfigurable) {
                    this.setNotConfigurable();
                }
                DefaultExecutionContext defaultExecutionContext = new DefaultExecutionContext(targetProfile, this.applicationContext, this.visitorBindings);
                return defaultExecutionContext;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalTCCL);
            }
        }
        if (this.isConfigurable) {
            this.setNotConfigurable();
        }
        return new DefaultExecutionContext(targetProfile, this.applicationContext, this.visitorBindings);
    }

    private synchronized void setNotConfigurable() {
        if (!this.isConfigurable) {
            return;
        }
        this.isConfigurable = false;
    }

    public void filterSource(Source source) throws SmooksException {
        this.filterSource(this.createExecutionContext(), source, null);
    }

    public void filterSource(Source source, Result ... results) throws SmooksException {
        this.filterSource(this.createExecutionContext(), source, results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterSource(ExecutionContext executionContext, Source source, Result ... results) throws SmooksException {
        AssertArgument.isNotNull(source, "source");
        AssertArgument.isNotNull(executionContext, "executionContext");
        if (this.applicationContext.getClassLoader() != null) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.applicationContext.getClassLoader());
            try {
                this._filter(executionContext, source, results);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        } else {
            this._filter(executionContext, source, results);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _filter(ExecutionContext executionContext, Source source, Result ... results) {
        ContentDeliveryConfig contentDeliveryConfig = executionContext.getContentDeliveryRuntime().getContentDeliveryConfig();
        try {
            FilterBypass filterBypass;
            this.lifecycleManager.applyPhase(((Map)this.registry.lookup(new InstanceLookup<FilterLifecycle>(FilterLifecycle.class))).values(), (LifecyclePhase)new PreFilterLifecyclePhase(executionContext));
            if (results != null && results.length == 1 && results[0] != null && (filterBypass = contentDeliveryConfig.getFilterBypass()) != null && filterBypass.bypass(executionContext, source, results[0])) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("FilterBypass {} applied", (Object)filterBypass.getClass().getName());
                }
                return;
            }
            Filter filter = contentDeliveryConfig.newFilter(executionContext);
            try {
                FilterSource.setSource(executionContext, source);
                FilterResult.setResults(executionContext, results);
                BeanContext beanContext = executionContext.getBeanContext();
                beanContext.addBean("PTIME", (Object)new Time());
                beanContext.addBean("PUUID", (Object)new UniqueID());
                for (BeanContextLifecycleObserver observer : this.applicationContext.getBeanContextLifecycleObservers()) {
                    beanContext.addObserver(observer);
                }
                try {
                    contentDeliveryConfig.executeHandlerInit(executionContext);
                    filter.doFilter();
                }
                finally {
                    try {
                        JavaResult javaResult = (JavaResult)FilterResult.getResult(executionContext, JavaResult.class);
                        if (javaResult != null) {
                            javaResult.getResultMap().putAll(executionContext.getBeanContext().getBeanMap());
                        }
                        beanContext.removeBean("PTIME", null);
                        beanContext.removeBean("PUUID", null);
                    }
                    finally {
                        contentDeliveryConfig.executeHandlerCleanup(executionContext);
                    }
                }
            }
            catch (SmooksException e) {
                executionContext.setTerminationError(e);
                throw e;
            }
            catch (Throwable t) {
                executionContext.setTerminationError(t);
                throw new SmooksException("Smooks Filtering operation failed", t);
            }
            finally {
                try {
                    filter.close();
                }
                catch (IOException e) {
                    throw new SmooksException(e);
                }
            }
        }
        finally {
            this.lifecycleManager.applyPhase(((Map)this.registry.lookup(new InstanceLookup<FilterLifecycle>(FilterLifecycle.class))).values(), (LifecyclePhase)new PostFilterLifecyclePhase(executionContext));
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public void close() {
        this.applicationContext.getRegistry().close();
    }

    private void assertIsConfigurable() {
        if (!this.isConfigurable) {
            throw new UnsupportedOperationException("Unsupported call to Smooks instance configuration method after Smooks instance has created an ExecutionContext.");
        }
    }
}

