/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import jakarta.annotation.Resource;
import java.text.ParseException;
import java.util.Properties;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.resource.config.Configurable;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;
import org.smooks.engine.converter.NumberTypeConverter;

@Resource(name="Double")
public class StringToDoubleConverterFactory
implements TypeConverterFactory<String, Double>,
Configurable {
    private Properties properties = new Properties();

    @Override
    public TypeConverter<String, Double> createTypeConverter() {
        StringToDoubleTypeConverter stringToDoubleTypeConverter = new StringToDoubleTypeConverter();
        stringToDoubleTypeConverter.setConfiguration(this.properties);
        return stringToDoubleTypeConverter;
    }

    @Override
    public TypeConverterDescriptor<Class<String>, Class<Double>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<Double>>(String.class, Double.class);
    }

    @Override
    public void setConfiguration(Properties properties) throws SmooksConfigException {
        this.properties = properties;
    }

    @Override
    public Properties getConfiguration() {
        return this.properties;
    }

    public static class StringToDoubleTypeConverter
    extends NumberTypeConverter<String, Double> {
        @Override
        protected Double doConvert(String value) {
            if (this.numberFormat != null) {
                try {
                    Number number = this.numberFormat.parse(value.trim());
                    return number.doubleValue();
                }
                catch (ParseException e) {
                    throw new TypeConverterException("Failed to decode Double value '" + value + "' using NumberFormat instance " + this.numberFormat + ".", e);
                }
            }
            try {
                return Double.parseDouble(value.trim());
            }
            catch (NumberFormatException e) {
                throw new TypeConverterException("Failed to decode Double value '" + value + "'.", e);
            }
        }
    }
}

