/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import jakarta.annotation.Resource;
import java.text.ParseException;
import java.util.Properties;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.api.resource.config.Configurable;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;
import org.smooks.engine.converter.NumberTypeConverter;

@Resource(name="Integer")
public class StringToIntegerConverterFactory
implements TypeConverterFactory<String, Integer>,
Configurable {
    private Properties properties = new Properties();

    @Override
    public TypeConverter<String, Integer> createTypeConverter() {
        NumberTypeConverter<String, Integer> numberTypeConverter = new NumberTypeConverter<String, Integer>(){

            @Override
            protected Integer doConvert(String value) {
                if (this.numberFormat != null) {
                    try {
                        Number number = this.numberFormat.parse(value.trim());
                        if (this.isPercentage()) {
                            return (int)(number.doubleValue() * 100.0);
                        }
                        return number.intValue();
                    }
                    catch (ParseException e) {
                        throw new TypeConverterException("Failed to decode Integer value '" + value + "' using NumberFormat instance " + this.numberFormat + ".", e);
                    }
                }
                try {
                    return Integer.parseInt(value.trim());
                }
                catch (NumberFormatException e) {
                    throw new TypeConverterException("Failed to decode Integer value '" + value + "'.", e);
                }
            }
        };
        numberTypeConverter.setConfiguration(this.properties);
        return numberTypeConverter;
    }

    @Override
    public TypeConverterDescriptor<Class<String>, Class<Integer>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<Integer>>(String.class, Integer.class);
    }

    @Override
    public void setConfiguration(Properties properties) throws SmooksConfigException {
        this.properties = properties;
    }

    @Override
    public Properties getConfiguration() {
        return this.properties;
    }
}

