/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.net.MalformedURLException;
import java.net.URL;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;

public class URLConverterFactory
implements TypeConverterFactory<String, URL> {
    @Override
    public TypeConverter<String, URL> createTypeConverter() {
        return value -> {
            try {
                return new URL(value.trim());
            }
            catch (MalformedURLException e) {
                throw new TypeConverterException("Failed to decode URL value '" + value + "'.", e);
            }
        };
    }

    @Override
    public TypeConverterDescriptor<Class<String>, Class<URL>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<URL>>(String.class, URL.class);
    }
}

