/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.smooks.api.Registry;
import org.smooks.api.delivery.ContentDeliveryConfigBuilder;
import org.smooks.api.delivery.ContentDeliveryRuntime;
import org.smooks.api.delivery.ContentDeliveryRuntimeFactory;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.delivery.ReaderPool;
import org.smooks.api.delivery.ReaderPoolFactory;
import org.smooks.api.profile.ProfileSet;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.engine.delivery.DefaultContentDeliveryConfigBuilder;
import org.smooks.engine.delivery.DefaultContentDeliveryRuntime;
import org.smooks.engine.delivery.dom.DOMFilterProvider;
import org.smooks.engine.delivery.sax.ng.SaxNgFilterProvider;
import org.smooks.engine.lookup.GlobalParamsLookup;

public class DefaultContentDeliveryRuntimeFactory
implements ContentDeliveryRuntimeFactory {
    private final Map<ContentDeliveryConfigBuilder, ReaderPool> readerPools = new HashMap<ContentDeliveryConfigBuilder, ReaderPool>();
    private final Map<String, ContentDeliveryConfigBuilder> contentDeliveryConfigBuilders = new HashMap<String, ContentDeliveryConfigBuilder>();
    private final Registry registry;
    private final ReaderPoolFactory readerPoolFactory;

    public DefaultContentDeliveryRuntimeFactory(Registry registry, ReaderPoolFactory readerPoolFactory) {
        this.registry = registry;
        this.readerPoolFactory = readerPoolFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContentDeliveryRuntime create(ProfileSet profileSet, List<ContentHandlerBinding<Visitor>> extendedContentHandlerBindings) {
        ContentDeliveryConfigBuilder contentDeliveryConfigBuilder = this.contentDeliveryConfigBuilders.get(profileSet.getBaseProfile());
        if (contentDeliveryConfigBuilder == null) {
            DefaultContentDeliveryRuntimeFactory defaultContentDeliveryRuntimeFactory = this;
            synchronized (defaultContentDeliveryRuntimeFactory) {
                if (this.contentDeliveryConfigBuilders.get(profileSet.getBaseProfile()) == null) {
                    contentDeliveryConfigBuilder = new DefaultContentDeliveryConfigBuilder(profileSet, this.registry, Arrays.asList(new SaxNgFilterProvider(), new DOMFilterProvider()));
                    int readerPoolSize = Integer.parseInt(this.registry.lookup(new GlobalParamsLookup(this.registry)).getParameterValue("reader.pool.size", String.class, "0"));
                    this.readerPools.put(contentDeliveryConfigBuilder, this.readerPoolFactory.create(readerPoolSize));
                    this.contentDeliveryConfigBuilders.put(profileSet.getBaseProfile(), contentDeliveryConfigBuilder);
                } else {
                    contentDeliveryConfigBuilder = this.contentDeliveryConfigBuilders.get(profileSet.getBaseProfile());
                }
            }
        }
        return new DefaultContentDeliveryRuntime(this.readerPools.get(contentDeliveryConfigBuilder), contentDeliveryConfigBuilder.build(extendedContentHandlerBindings));
    }
}

