/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.dom;

import java.io.IOException;
import java.nio.charset.Charset;
import javax.xml.transform.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.delivery.ReaderPool;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.engine.delivery.AbstractParser;
import org.smooks.engine.delivery.XMLReaderHierarchyChangeListener;
import org.smooks.engine.delivery.dom.DOMBuilderContentHandler;
import org.smooks.engine.xml.NamespaceManager;
import org.smooks.namespace.NamespaceDeclarationStack;
import org.smooks.xml.hierarchy.HierarchyChangeReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DOMParser
extends AbstractParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(DOMParser.class);

    public DOMParser(ExecutionContext executionContext) {
        super(executionContext);
    }

    public DOMParser(ExecutionContext executionContext, ResourceConfig saxDriverConfig) {
        super(executionContext, saxDriverConfig);
    }

    public Document parse(Source source) throws IOException, SAXException {
        DOMBuilderContentHandler contentHandler = new DOMBuilderContentHandler(this.getExecutionContext());
        this.parse(source, contentHandler);
        return contentHandler.getDocument();
    }

    public void append(Source source, Element appendElement) throws IOException, SAXException {
        DOMBuilderContentHandler contentHandler = new DOMBuilderContentHandler(this.getExecutionContext());
        contentHandler.setAppendElement(appendElement);
        this.parse(source, contentHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(Source source, DOMBuilderContentHandler contentHandler) throws SAXException, IOException {
        ExecutionContext executionContext = this.getExecutionContext();
        if (executionContext != null) {
            ReaderPool readerPool = executionContext.getContentDeliveryRuntime().getReaderPool();
            XMLReader domReader = DOMParser.getXMLReader(executionContext);
            try {
                if (domReader == null) {
                    domReader = readerPool.borrowXMLReader();
                }
                if (domReader == null) {
                    domReader = this.createXMLReader();
                }
                if (domReader instanceof HierarchyChangeReader) {
                    ((HierarchyChangeReader)((Object)domReader)).setHierarchyChangeListener(new XMLReaderHierarchyChangeListener(executionContext));
                }
                NamespaceDeclarationStack namespaceDeclarationStack = new NamespaceDeclarationStack();
                executionContext.put(NamespaceManager.NAMESPACE_DECLARATION_STACK_TYPED_KEY, namespaceDeclarationStack);
                this.attachNamespaceDeclarationStack(domReader, executionContext);
                DOMParser.attachXMLReader(domReader, executionContext);
                this.configureReader(domReader, contentHandler, executionContext, source);
                domReader.parse(this.createInputSource(source, executionContext.getContentEncoding()));
            }
            finally {
                try {
                    if (domReader instanceof HierarchyChangeReader) {
                        ((HierarchyChangeReader)((Object)domReader)).setHierarchyChangeListener(null);
                    }
                }
                finally {
                    try {
                        try {
                            DOMParser.detachXMLReader(executionContext);
                        }
                        finally {
                            if (domReader != null) {
                                readerPool.returnXMLReader(domReader);
                            }
                        }
                    }
                    finally {
                        contentHandler.detachHandler();
                    }
                }
            }
        }
        XMLReader domReader = this.createXMLReader();
        this.configureReader(domReader, contentHandler, null, source);
        domReader.parse(this.createInputSource(source, Charset.defaultCharset().name()));
    }
}

