/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.interceptor;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.smooks.api.ApplicationContext;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ContentHandlerBinding;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.interceptor.InterceptorVisitor;
import org.smooks.engine.delivery.DefaultContentHandlerBinding;
import org.smooks.engine.delivery.interceptor.InterceptorVisitorDefinition;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.smooks.engine.resource.config.DefaultResourceConfig;

public class InterceptorVisitorChainFactory {
    protected final List<InterceptorVisitorDefinition> interceptorVisitorDefinitions = new ArrayList<InterceptorVisitorDefinition>();
    protected final ApplicationContext applicationContext;

    public InterceptorVisitorChainFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public ContentHandlerBinding<Visitor> createInterceptorChain(ContentHandlerBinding<Visitor> visitorBinding) {
        if (this.interceptorVisitorDefinitions.isEmpty()) {
            return visitorBinding;
        }
        ContentHandlerBinding<Visitor> interceptedVisitorBinding = visitorBinding;
        for (InterceptorVisitorDefinition interceptorVisitorDefinition : this.applyCustomFirstSystemLastOrder(this.interceptorVisitorDefinitions)) {
            InterceptorVisitor interceptorVisitor;
            try {
                interceptorVisitor = interceptorVisitorDefinition.getInterceptorVisitorClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new SmooksException(e.getMessage(), e);
            }
            interceptorVisitor.setVisitorBinding(interceptedVisitorBinding);
            DefaultResourceConfig interceptorResourceConfig = new DefaultResourceConfig(visitorBinding.getResourceConfig());
            if (!interceptorVisitorDefinition.getResourceConfig().getSelectorPath().getSelector().equals("none")) {
                interceptorResourceConfig.setSelector(interceptorVisitorDefinition.getResourceConfig().getSelectorPath().getSelector(), interceptorResourceConfig.getSelectorPath().getNamespaces());
            }
            this.applicationContext.getRegistry().lookup(new LifecycleManagerLookup()).applyPhase(interceptorVisitor, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(this.applicationContext.getRegistry(), interceptorResourceConfig, interceptorVisitor)));
            interceptedVisitorBinding = new DefaultContentHandlerBinding<InterceptorVisitor>(interceptorVisitor, interceptorResourceConfig);
        }
        return interceptedVisitorBinding;
    }

    protected List<InterceptorVisitorDefinition> applyCustomFirstSystemLastOrder(List<InterceptorVisitorDefinition> interceptorVisitorDefinitions) {
        ArrayList<InterceptorVisitorDefinition> systemInterceptorVisitorDefinitions = new ArrayList<InterceptorVisitorDefinition>();
        ArrayList<InterceptorVisitorDefinition> nonSystemInterceptorVisitorDefinitions = new ArrayList<InterceptorVisitorDefinition>();
        for (InterceptorVisitorDefinition interceptorVisitorDefinition : interceptorVisitorDefinitions) {
            if (interceptorVisitorDefinition.getResourceConfig().isSystem()) {
                systemInterceptorVisitorDefinitions.add(interceptorVisitorDefinition);
                continue;
            }
            nonSystemInterceptorVisitorDefinitions.add(interceptorVisitorDefinition);
        }
        return Stream.concat(nonSystemInterceptorVisitorDefinitions.stream(), systemInterceptorVisitorDefinitions.stream()).collect(Collectors.toList());
    }

    public List<InterceptorVisitorDefinition> getInterceptorVisitorDefinitions() {
        return this.interceptorVisitorDefinitions;
    }
}

