/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.sax.ng.bridge;

import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Bridge {
    private final Node node;

    public Bridge(Node node) {
        if (!Bridge.isBridge(node)) {
            throw new SmooksException("Node is not a bridge element");
        }
        this.node = node;
    }

    public static boolean isBridge(Node node) {
        return node instanceof Element && node.getNamespaceURI() != null && node.getNamespaceURI().equals("https://www.smooks.org") && node.getLocalName().equals("bridge");
    }

    public TypedKey<Node> getSourceKey() {
        return TypedKey.of(this.node.getAttributes().getNamedItem("source").getNodeValue());
    }

    public String getVisit() {
        return this.node.getAttributes().getNamedItem("visit").getNodeValue();
    }

    public Node getSourceValue(ExecutionContext executionContext) {
        return executionContext.get(this.getSourceKey());
    }
}

