/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.profile;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.smooks.api.profile.Profile;
import org.smooks.api.profile.ProfileSet;
import org.smooks.engine.profile.BasicProfile;

public class DefaultProfileSet
extends LinkedHashMap<String, Profile>
implements ProfileSet {
    private static final long serialVersionUID = 1L;
    private final String baseProfile;

    public DefaultProfileSet(String baseProfile) {
        this.baseProfile = baseProfile;
    }

    public DefaultProfileSet(String baseProfile, String[] subProfiles) {
        this(baseProfile);
        this.addProfiles(subProfiles);
    }

    @Override
    public String getBaseProfile() {
        return this.baseProfile;
    }

    @Override
    public boolean isMember(String profile) {
        if (profile == null) {
            throw new IllegalArgumentException("null 'profile' arg in method call.");
        }
        if (profile.equalsIgnoreCase(this.baseProfile)) {
            return true;
        }
        return this.containsKey(profile.trim());
    }

    public void addProfile(String profile) {
        this.addProfile(new BasicProfile(profile));
    }

    @Override
    public void addProfile(Profile profile) {
        if (profile == null) {
            throw new IllegalArgumentException("null 'profile' arg in method call.");
        }
        this.put(profile.getName(), profile);
    }

    @Override
    public Profile getProfile(String profile) {
        return (Profile)this.get(profile);
    }

    @Override
    public Iterator<Profile> iterator() {
        return this.values().iterator();
    }

    protected void addProfileSet(DefaultProfileSet profileSet) {
        if (profileSet == null) {
            throw new IllegalArgumentException("null 'profileSet' arg in method call.");
        }
        this.putAll(profileSet);
    }

    public void addProfiles(String[] subProfiles) {
        if (subProfiles == null) {
            return;
        }
        for (String subProfile : subProfiles) {
            this.addProfile(new BasicProfile(subProfile));
        }
    }

    @Override
    public String toString() {
        StringBuilder setDescription = new StringBuilder();
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            String profile = (String)iterator.next();
            setDescription.append(profile);
            if (!iterator.hasNext()) continue;
            setDescription.append(",");
        }
        return setDescription.toString();
    }
}

