/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config;

import org.smooks.api.profile.Profile;
import org.smooks.api.profile.ProfileSet;
import org.smooks.api.resource.config.ProfileTargetingExpression;

public class DefaultProfileTargetingExpression
implements ProfileTargetingExpression {
    private final String expression;
    private final ExpressionToken[] expressionTokens;

    public DefaultProfileTargetingExpression(String expression) {
        if (expression == null || expression.trim().equals("")) {
            throw new IllegalArgumentException("null or empty 'expression' arg.");
        }
        this.expression = expression;
        String[] tokens = expression.split(" AND ");
        this.expressionTokens = new ExpressionToken[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i].trim();
            this.expressionTokens[i] = new ExpressionToken(token);
        }
    }

    @Override
    public boolean isMatch(ProfileSet profileSet) {
        for (ExpressionToken expressionToken : this.expressionTokens) {
            if (expressionToken.isMatch(profileSet)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double getSpecificity(ProfileSet profileSet) {
        double specificity = 0.0;
        if (this.isMatch(profileSet)) {
            for (ExpressionToken expressionToken : this.expressionTokens) {
                if (!expressionToken.isMatch(profileSet)) continue;
                specificity += expressionToken.getSpecificity(profileSet);
            }
        }
        return specificity;
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    protected ExpressionToken[] getExpressionTokens() {
        return this.expressionTokens;
    }

    public String toString() {
        return this.expression;
    }

    protected static class ExpressionToken {
        private final String expressionToken;
        private final boolean negated;

        private ExpressionToken(String expressionToken) {
            this.negated = expressionToken.startsWith("not:");
            this.expressionToken = this.negated ? expressionToken.substring(4) : expressionToken;
        }

        public String getToken() {
            return this.expressionToken;
        }

        public boolean isNegated() {
            return this.negated;
        }

        public boolean isWildcard() {
            return this.expressionToken.equals("*");
        }

        public boolean isMatch(ProfileSet profileSet) {
            if (this.isWildcard()) {
                return true;
            }
            if (this.negated) {
                return !profileSet.isMember(this.expressionToken);
            }
            return profileSet.isMember(this.expressionToken);
        }

        public double getSpecificity(ProfileSet profileSet) {
            if (this.isNegated()) {
                if (profileSet.getBaseProfile().equals(this.expressionToken)) {
                    return 0.0;
                }
                if (profileSet.isMember(this.expressionToken)) {
                    return 0.0;
                }
                if (this.isWildcard()) {
                    return 0.0;
                }
                return 1.0;
            }
            Profile profile = profileSet.getProfile(this.expressionToken);
            if (profileSet.getBaseProfile().equalsIgnoreCase(this.expressionToken)) {
                return 100.0;
            }
            if (profile != null) {
                return 10.0;
            }
            if (this.isWildcard()) {
                return 5.0;
            }
            return 0.0;
        }

        public String toString() {
            return this.expressionToken;
        }
    }
}

