/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.profile.Profile;
import org.smooks.api.resource.config.Parameter;
import org.smooks.api.resource.config.ProfileTargetingExpression;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigChangeListener;
import org.smooks.api.resource.config.xpath.SelectorPath;
import org.smooks.engine.resource.config.DefaultParameter;
import org.smooks.engine.resource.config.DefaultProfileTargetingExpression;
import org.smooks.engine.resource.config.xpath.SelectorPathFactory;
import org.smooks.resource.URIResourceLocator;
import org.smooks.support.ClassUtils;
import org.smooks.support.StreamUtils;
import org.smooks.support.XmlUtils;
import org.w3c.dom.Element;

public class DefaultResourceConfig
implements ResourceConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultResourceConfig.class);
    private static final URIResourceLocator uriResourceLocator = new URIResourceLocator();
    private SelectorPath selectorPath;
    private String profile;
    private String[] profileTargetingExpressionStrings;
    private ProfileTargetingExpression[] profileTargetingExpressions;
    private String resource;
    private boolean isInline;
    private String resourceType;
    private LinkedHashMap<String, Object> parameters = new LinkedHashMap();
    private int parameterCount;
    private boolean defaultResource;
    private final Set<ResourceConfigChangeListener> changeListeners = new HashSet<ResourceConfigChangeListener>();

    public DefaultResourceConfig() {
        this.setSelector("none", new Properties());
        this.setProfile(Profile.DEFAULT_PROFILE);
    }

    public DefaultResourceConfig(String selector, Properties namespaces) {
        this.setSelector(selector, namespaces);
        this.setProfile(Profile.DEFAULT_PROFILE);
    }

    public DefaultResourceConfig(ResourceConfig resourceConfig) {
        this.setProfile(resourceConfig.getProfile());
        this.setResource(resourceConfig.getResource());
        this.setSelectorPath(SelectorPathFactory.newSelectorPath(resourceConfig.getSelectorPath()));
        this.setSystem(resourceConfig.isSystem());
    }

    public DefaultResourceConfig(String selector, Properties namespaces, String resource) {
        this(selector, namespaces, Profile.DEFAULT_PROFILE, resource);
    }

    public DefaultResourceConfig(String selector, Properties namespaces, String profile, String resource) {
        this(selector, namespaces);
        this.setProfile(profile);
        this.setResource(resource);
    }

    @Override
    public ResourceConfig copy() {
        DefaultResourceConfig copyResourceConfig = new DefaultResourceConfig();
        copyResourceConfig.selectorPath = SelectorPathFactory.newSelectorPath(this.selectorPath);
        copyResourceConfig.profile = this.profile;
        copyResourceConfig.defaultResource = this.defaultResource;
        copyResourceConfig.profileTargetingExpressionStrings = this.profileTargetingExpressionStrings;
        copyResourceConfig.profileTargetingExpressions = this.profileTargetingExpressions;
        copyResourceConfig.resource = this.resource;
        copyResourceConfig.isInline = this.isInline;
        copyResourceConfig.resourceType = this.resourceType;
        if (this.parameters != null) {
            copyResourceConfig.parameters = (LinkedHashMap)this.parameters.clone();
        }
        copyResourceConfig.parameterCount = this.parameterCount;
        return copyResourceConfig;
    }

    @Override
    public void addParameters(ResourceConfig resourceConfig) {
        this.parameters.putAll(resourceConfig.getParameters());
    }

    @Override
    public void setSelector(String selector, Properties namespaces) {
        if (selector != null) {
            if (this.selectorPath == null) {
                this.selectorPath = SelectorPathFactory.newSelectorPath(selector, namespaces);
            } else {
                this.selectorPath = SelectorPathFactory.newSelectorPath(selector, this.selectorPath.getNamespaces(), this.selectorPath.getConditionEvaluator());
                this.selectorPath.getNamespaces().putAll((Map<?, ?>)namespaces);
            }
        } else {
            this.selectorPath = SelectorPathFactory.newSelectorPath("none", namespaces);
        }
        this.fireChangedEvent();
    }

    @Override
    public void setResource(String resource) {
        this.resource = resource;
        if (resource != null) {
            try {
                new URI(resource);
                this.isInline = false;
            }
            catch (Exception e) {
                this.isInline = true;
            }
        }
        this.fireChangedEvent();
    }

    @Override
    public boolean isInline() {
        return this.isInline;
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public void setProfile(String profile) {
        if (profile == null || profile.trim().isEmpty()) {
            profile = Profile.DEFAULT_PROFILE;
        }
        this.profile = profile;
        this.parseTargetingExpressions(profile);
    }

    @Override
    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    @Override
    public void setSelectorPath(SelectorPath selectorPath) {
        this.selectorPath = selectorPath;
        this.fireChangedEvent();
    }

    @Override
    public SelectorPath getSelectorPath() {
        return this.selectorPath;
    }

    @Override
    public ProfileTargetingExpression[] getProfileTargetingExpressions() {
        return this.profileTargetingExpressions;
    }

    @Override
    public String getResource() {
        return this.resource;
    }

    @Override
    public boolean isSystem() {
        return this.defaultResource;
    }

    @Override
    public void setSystem(boolean isSystem) {
        this.defaultResource = isSystem;
    }

    @Override
    public String getResourceType() {
        if (this.isJavaResource()) {
            return "class";
        }
        String resourceType = this.resourceType != null ? this.resourceType : this.getExtension(this.getResource());
        return resourceType;
    }

    private void parseTargetingExpressions(String targetProfiles) {
        StringTokenizer tokenizer = new StringTokenizer(targetProfiles, ",|;");
        if (tokenizer.countTokens() == 0) {
            throw new IllegalArgumentException("Empty 'target-profile'. [" + this.selectorPath.getSelector() + "][" + this.resource + "]");
        }
        this.profileTargetingExpressionStrings = new String[tokenizer.countTokens()];
        this.profileTargetingExpressions = new DefaultProfileTargetingExpression[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String expression;
            this.profileTargetingExpressionStrings[i] = expression = tokenizer.nextToken();
            this.profileTargetingExpressions[i] = new DefaultProfileTargetingExpression(expression);
            ++i;
        }
    }

    private String getExtension(String path) {
        int extensionIndex;
        File resFile;
        String resName;
        if (path != null && !(resName = (resFile = new File(path)).getName()).trim().equals("") && (extensionIndex = resName.lastIndexOf(46)) != -1 && extensionIndex + 1 < resName.length()) {
            return resName.substring(extensionIndex + 1);
        }
        return null;
    }

    @Override
    public <T> Parameter<T> setParameter(String name, T value) {
        DefaultParameter<T> param = new DefaultParameter<T>(name, value);
        this.setParameter(param);
        return param;
    }

    @Override
    public <T> Parameter<T> setParameter(String name, String type, T value) {
        DefaultParameter<T> param = new DefaultParameter<T>(name, value, type);
        this.setParameter(param);
        return param;
    }

    @Override
    public <T> void setParameter(Parameter<T> parameter) {
        Object exists;
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap();
        }
        if ((exists = this.parameters.get(parameter.getName())) == null) {
            this.parameters.put(parameter.getName(), parameter);
        } else if (exists instanceof Parameter) {
            Vector<Parameter<T>> paramList = new Vector<Parameter<T>>();
            paramList.add((Parameter)exists);
            paramList.add(parameter);
            this.parameters.put(parameter.getName(), paramList);
        } else if (exists instanceof List) {
            ((List)exists).add(parameter);
        }
        ++this.parameterCount;
    }

    @Override
    public <T> Parameter<T> getParameter(String name, Class<T> valueClass) {
        if (this.parameters == null) {
            return null;
        }
        Object parameter = this.parameters.get(name);
        if (parameter instanceof List) {
            return (Parameter)((List)parameter).get(0);
        }
        if (parameter instanceof Parameter) {
            return (Parameter)parameter;
        }
        return null;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public List<?> getParameterValues() {
        if (this.parameters == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Object>(this.parameters.values());
    }

    @Override
    public List<Parameter<?>> getParameters(String name) {
        if (this.parameters != null) {
            Object parameter = this.parameters.get(name);
            if (parameter instanceof List) {
                return (List)parameter;
            }
            if (parameter instanceof Parameter) {
                ArrayList paramList = new ArrayList();
                paramList.add((Parameter)parameter);
                return paramList;
            }
        }
        return Collections.emptyList();
    }

    @Override
    public Object getParameterValue(String name) {
        Parameter<Object> parameter = this.getParameter(name, Object.class);
        return parameter != null ? parameter.getValue() : null;
    }

    @Override
    public <T> T getParameterValue(String name, Class<T> valueClass) {
        Parameter<T> parameter = this.getParameter(name, valueClass);
        return parameter != null ? (T)parameter.getValue() : null;
    }

    @Override
    public <T> T getParameterValue(String name, Class<T> valueClass, T defaultValue) {
        T value = this.getParameterValue(name, valueClass);
        return value != null ? value : defaultValue;
    }

    @Override
    public int getParameterCount() {
        return this.parameterCount;
    }

    @Override
    public void removeParameter(String name) {
        this.parameters.remove(name);
    }

    public String toString() {
        return "Target Profile: [" + Arrays.asList(this.profileTargetingExpressionStrings) + "], Selector: [" + this.selectorPath.getSelector() + "], Resource: [" + this.resource + "], Num Params: [" + this.getParameterCount() + "]";
    }

    @Override
    public byte[] getBytes() {
        if (this.resource != null) {
            InputStream resStream;
            try {
                resStream = uriResourceLocator.getResource(this.resource);
            }
            catch (Exception e) {
                return this.getInlineResourceBytes();
            }
            try {
                byte[] resourceBytes;
                if (resStream == null) {
                    throw new IOException("Resource [" + this.resource + "] not found.");
                }
                try {
                    resourceBytes = StreamUtils.readStream(resStream);
                }
                finally {
                    resStream.close();
                }
                return resourceBytes;
            }
            catch (IOException e) {
                return this.getInlineResourceBytes();
            }
        }
        return null;
    }

    private byte[] getInlineResourceBytes() {
        return this.resource.getBytes(StandardCharsets.UTF_8);
    }

    protected Class<?> toJavaResource() {
        if (this.resource == null || this.resource.trim().length() < 1) {
            return null;
        }
        String className = ClassUtils.toClassName(this.resource);
        try {
            return ClassUtils.forName(className, this.getClass());
        }
        catch (ClassNotFoundException e) {
            if (this.resource.equals(className)) {
                LOGGER.debug("Resource path [" + this.resource + "] looks as though it may be a Java resource reference.  If so, this class is not available on the classpath.");
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            if (this.resource.equals(className)) {
                LOGGER.debug("The string [" + this.resource + "] contains unescaped characters that are illegal in a Java resource name.");
            }
            return null;
        }
    }

    @Override
    public boolean isJavaResource() {
        return this.toJavaResource() != null;
    }

    @Override
    public void addChangeListener(ResourceConfigChangeListener resourceConfigChangeListener) {
        this.changeListeners.add(resourceConfigChangeListener);
    }

    @Override
    public void removeChangeListener(ResourceConfigChangeListener resourceConfigChangeListener) {
        this.changeListeners.remove(resourceConfigChangeListener);
    }

    @Override
    public String toXml() {
        StringBuilder builder = new StringBuilder();
        builder.append("<resource-config selector=\"").append(this.selectorPath.getSelector()).append("\"");
        if (this.profile != null && !this.profile.equals(Profile.DEFAULT_PROFILE)) {
            builder.append(" target-profile=\"").append(this.profile).append("\"");
        }
        builder.append(">\n");
        if (this.resource != null) {
            String resourceStartEl = this.resourceType != null ? "<resource type=\"" + this.resourceType + "\">" : "<resource>";
            builder.append("\t").append(resourceStartEl);
            if (this.resource.length() < 300) {
                builder.append(this.resource).append("</resource>\n");
            } else {
                builder.append(this.resource, 0, 300).append(" ... more</resource>\n");
            }
        }
        if (this.selectorPath.getConditionEvaluator() != null) {
            builder.append("\t<condition evaluator=\"").append(this.selectorPath.getConditionEvaluator().getClass().getName()).append("\">").append(this.selectorPath.getConditionEvaluator().getExpression()).append("</condition>\n");
        }
        if (this.parameters != null) {
            Set<String> paramNames = this.parameters.keySet();
            for (String paramName : paramNames) {
                List<Parameter<?>> params = this.getParameters(paramName);
                for (Parameter<?> param : params) {
                    Element element = param.getXml();
                    Object value = element != null ? XmlUtils.serialize(element.getChildNodes(), true) : param.getValue();
                    builder.append("\t<param name=\"").append(paramName).append("\">").append(value).append("</param>\n");
                }
            }
        }
        builder.append("</resource-config>");
        return builder.toString();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public Properties toProperties() {
        Properties properties = new Properties();
        Set<String> names = this.parameters.keySet();
        for (String name : names) {
            properties.setProperty(name, this.getParameterValue(name).toString());
        }
        return properties;
    }

    protected void fireChangedEvent() {
        if (!this.changeListeners.isEmpty()) {
            for (ResourceConfigChangeListener listener : this.changeListeners) {
                listener.changed(this);
            }
        }
    }
}

