/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.smooks.api.resource.config.ParameterDecodeException;
import org.smooks.engine.resource.config.ParameterDecoder;

public class PropertyListParameterDecoder
extends ParameterDecoder<String> {
    @Override
    public Object decodeValue(String value) throws ParameterDecodeException {
        Properties properties = new Properties();
        try {
            properties.load(new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8)));
        }
        catch (UnsupportedEncodingException e) {
            throw new ParameterDecodeException("Unexpected error.  'UTF-8' is not a supported character encoding.", e);
        }
        catch (IOException e) {
            throw new ParameterDecodeException("Unexpected error.  Unable to read ByteArrayInputStream based stream.", e);
        }
        return properties;
    }
}

