/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config.loader.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.Smooks;
import org.smooks.api.ApplicationContextBuilder;
import org.smooks.api.ExecutionContext;
import org.smooks.api.Registry;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.expression.ExpressionEvaluator;
import org.smooks.api.resource.config.Parameter;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigFactory;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.api.resource.config.loader.ResourceConfigLoader;
import org.smooks.engine.DefaultApplicationContextBuilder;
import org.smooks.engine.expression.ExpressionEvaluatorFactory;
import org.smooks.engine.profile.DefaultProfileSet;
import org.smooks.engine.resource.config.DefaultResourceConfig;
import org.smooks.engine.resource.config.DefaultResourceConfigFactory;
import org.smooks.engine.resource.config.DefaultResourceConfigSeq;
import org.smooks.engine.resource.config.loader.xml.extension.ExtensionContext;
import org.smooks.resource.URIResourceLocator;
import org.smooks.support.ClassUtils;
import org.smooks.support.DomUtils;
import org.smooks.support.StreamUtils;
import org.smooks.support.URIUtil;
import org.smooks.support.XmlUtils;
import org.smooks.xml.XsdDOMValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlResourceConfigLoader
implements ResourceConfigLoader {
    public static final String XSD_V20 = "https://www.smooks.org/xsd/smooks-2.0.xsd";
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlResourceConfigLoader.class);
    private static final ThreadLocal<Boolean> EXTENSION_DIGEST_ON = new ThreadLocal();
    private final ExpressionEvaluatorFactory expressionEvaluatorFactory = new ExpressionEvaluatorFactory();
    private Map<String, Smooks> extendedResourceConfigLoaders = new HashMap<String, Smooks>();
    private ClassLoader classLoader;
    private ResourceConfigSeq resourceConfigSeq;
    private final Stack<SmooksConfig> configStack = new Stack();

    public XmlResourceConfigLoader() {
    }

    protected XmlResourceConfigLoader(ResourceConfigSeq resourceConfigSeq) {
        this.resourceConfigSeq = resourceConfigSeq;
        this.configStack.push(new SmooksConfig("root-config"));
    }

    @Override
    public ResourceConfigSeq load(InputStream inputStream, String baseURI, ClassLoader classLoader) {
        DefaultResourceConfigSeq resourceConfigSeq = new DefaultResourceConfigSeq(baseURI);
        XmlResourceConfigLoader.setExtensionDigestOff();
        XmlResourceConfigLoader xmlResourceConfigLoader = new XmlResourceConfigLoader(resourceConfigSeq);
        xmlResourceConfigLoader.classLoader = classLoader;
        xmlResourceConfigLoader.extendedResourceConfigLoaders = this.extendedResourceConfigLoaders;
        try {
            xmlResourceConfigLoader.loadConfigRecursively(new InputStreamReader(inputStream), baseURI);
        }
        catch (IOException | URISyntaxException | SAXException e) {
            throw new SmooksConfigException(e);
        }
        this.resourceConfigSeq = resourceConfigSeq;
        return resourceConfigSeq;
    }

    public ResourceConfigSeq getResourceConfigSeq() {
        return this.resourceConfigSeq;
    }

    protected void loadConfigRecursively(Reader reader, String baseURI) throws IOException, SAXException, URISyntaxException, SmooksConfigException {
        Document document;
        String streamData = StreamUtils.readStream(reader);
        try {
            document = XmlUtils.parseStream(new StringReader(streamData));
        }
        catch (ParserConfigurationException e) {
            throw new SmooksConfigException("Unable to parse Smooks configuration.", e);
        }
        XsdDOMValidator validator = new XsdDOMValidator(document);
        String defaultNS = validator.getDefaultNamespace().toString();
        validator.validate();
        if (!XSD_V20.equals(defaultNS)) {
            throw new SmooksConfigException("Cannot parse Smooks configuration.  Unsupported default Namespace '" + defaultNS + "'.");
        }
        this.loadV20XSDValidatedConfig(baseURI, document);
        if (this.resourceConfigSeq.isEmpty()) {
            throw new SmooksConfigException("Invalid Content Delivery Resource archive definition file: 0 Content Delivery Resource definitions.");
        }
    }

    protected void loadV20XSDValidatedConfig(String baseURI, Document configDoc) throws SAXException, URISyntaxException, SmooksConfigException {
        Element currentElement = configDoc.getDocumentElement();
        String defaultProfile = DomUtils.getAttributeValue(currentElement, "default-target-profile");
        String defaultConditionRef = DomUtils.getAttributeValue(currentElement, "default-condition-ref");
        NodeList configNodes = currentElement.getChildNodes();
        for (int i = 0; i < configNodes.getLength(); ++i) {
            if (configNodes.item(i).getNodeType() != 1) continue;
            Element configElement = (Element)configNodes.item(i);
            this.assertElementPermitted(configElement);
            String elementName = DomUtils.getName(configElement);
            String namespaceURI = configElement.getNamespaceURI();
            if (namespaceURI == null || namespaceURI.equals(XSD_V20)) {
                if (elementName.equals("params")) {
                    this.digestParams(configElement);
                    continue;
                }
                if (elementName.equals("conditions")) {
                    this.digestConditions(configElement);
                    continue;
                }
                if (elementName.equals("profiles")) {
                    this.digestProfiles(configElement);
                    continue;
                }
                if (elementName.equals("import")) {
                    this.digestImport(configElement, new URI(baseURI));
                    continue;
                }
                if (elementName.equals("reader")) {
                    this.loadReaderResourceConfig(configElement, defaultProfile);
                    continue;
                }
                if (!elementName.equals("resource-config")) continue;
                this.loadResourceConfig(configElement, defaultProfile, defaultConditionRef);
                continue;
            }
            this.loadExtendedResourceConfig(configElement, defaultProfile, defaultConditionRef);
        }
    }

    protected void digestParams(Element paramsElement) {
        NodeList paramNodes = paramsElement.getElementsByTagName("param");
        if (paramNodes.getLength() > 0) {
            DefaultResourceConfig globalParamsConfig = new DefaultResourceConfig("global-parameters", new Properties());
            this.digestParameters(paramsElement, globalParamsConfig);
            this.resourceConfigSeq.add(globalParamsConfig);
        }
    }

    protected void assertElementPermitted(Element configElement) {
        String elementName;
        if (XmlResourceConfigLoader.isExtensionConfig() && !(elementName = DomUtils.getName(configElement)).equals("import") && !elementName.equals("resource-config")) {
            throw new SmooksConfigException("Configuration element '" + elementName + "' not supported in an extension configuration.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void digestImport(Element importElement, URI baseURI) throws SAXException, URISyntaxException, SmooksConfigException {
        String file = DomUtils.getAttributeValue(importElement, "file");
        if (file == null) {
            throw new IllegalStateException("Invalid resource import.  'file' attribute must be specified.");
        }
        URIResourceLocator resourceLocator = new URIResourceLocator();
        resourceLocator.setBaseURI(baseURI);
        try {
            URI fileURI = resourceLocator.resolveURI(file);
            this.pushConfig(file, fileURI);
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Importing resource configuration '" + file + "' from inside '" + this.configStack.peek().configFile + "'.");
                }
                try (InputStream resourceStream = resourceLocator.getResource(file);){
                    List importParams = DomUtils.getElements(importElement, "param", null);
                    if (!importParams.isEmpty()) {
                        String importConfig = StreamUtils.readStreamAsString(resourceStream, "UTF-8");
                        for (Element importParam : importParams) {
                            String paramName = DomUtils.getAttributeValue(importParam, "name");
                            String paramValue = XmlUtils.serialize(importParam.getChildNodes(), true);
                            importConfig = importConfig.replaceAll("@" + paramName + "@", paramValue);
                        }
                        this.loadConfigRecursively(new StringReader(importConfig), URIUtil.getParent(fileURI).toString());
                    } else {
                        this.loadConfigRecursively(new InputStreamReader(resourceStream), URIUtil.getParent(fileURI).toString());
                    }
                }
            }
            finally {
                this.popConfig();
            }
        }
        catch (IOException e) {
            throw new SmooksConfigException("Failed to load Smooks configuration resource <import> '" + file + "': " + e.getMessage(), e);
        }
    }

    protected void loadReaderResourceConfig(Element configElement, String defaultProfile) {
        String profiles = DomUtils.getAttributeValue(configElement, "targetProfile");
        String readerClass = DomUtils.getAttributeValue(configElement, "class");
        DefaultResourceConfig resourceConfig = new DefaultResourceConfig("org.xml.sax.driver", new Properties(), profiles != null ? profiles : defaultProfile, readerClass);
        this.configureHandlers(configElement, resourceConfig);
        this.configureFeatures(configElement, resourceConfig);
        this.configureParams(configElement, resourceConfig);
        this.resourceConfigSeq.add(resourceConfig);
    }

    protected void configureHandlers(Element configElement, ResourceConfig resourceConfig) {
        Element handlersElement = DomUtils.getElement(configElement, "handlers", 1);
        if (handlersElement != null) {
            NodeList handlers = handlersElement.getChildNodes();
            for (int i = 0; i < handlers.getLength(); ++i) {
                if (handlers.item(i).getNodeType() != 1) continue;
                Element handler = (Element)handlers.item(i);
                String handlerClass = handler.getAttribute("class");
                resourceConfig.setParameter("sax-handler", handlerClass);
            }
        }
    }

    protected void configureFeatures(Element configElement, ResourceConfig resourceConfig) {
        Element featuresElement = DomUtils.getElement(configElement, "features", 1);
        if (featuresElement != null) {
            NodeList features = featuresElement.getChildNodes();
            for (int i = 0; i < features.getLength(); ++i) {
                if (features.item(i).getNodeType() != 1) continue;
                Element feature = (Element)features.item(i);
                String uri = feature.getAttribute("feature");
                if (DomUtils.getName(feature).equals("setOn")) {
                    resourceConfig.setParameter("feature-on", uri);
                    continue;
                }
                resourceConfig.setParameter("feature-off", uri);
            }
        }
    }

    protected void configureParams(Element configElement, ResourceConfig resourceConfig) {
        Element paramsElement = DomUtils.getElement(configElement, "params", 1);
        if (paramsElement != null) {
            NodeList params = paramsElement.getChildNodes();
            for (int i = 0; i < params.getLength(); ++i) {
                if (params.item(i).getNodeType() != 1) continue;
                Element param = (Element)params.item(i);
                String name = param.getAttribute("name");
                String value = DomUtils.getAllText(param, true);
                resourceConfig.setParameter(name, value);
            }
        }
    }

    protected void loadResourceConfig(Element configElement, String defaultProfile, String defaultConditionRef) {
        ResourceConfig resourceConfig;
        String factory = DomUtils.getAttributeValue(configElement, "factory");
        try {
            Class resourceConfigFactoryClass = factory != null ? Class.forName(factory, true, this.classLoader) : DefaultResourceConfigFactory.class;
            try {
                ResourceConfigFactory resourceConfigFactory = (ResourceConfigFactory)resourceConfigFactoryClass.newInstance();
                resourceConfig = resourceConfigFactory.create(defaultProfile, configElement);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new SmooksConfigException(e.getMessage(), e);
            }
            Element conditionElement = DomUtils.getElementByTagName(configElement, "condition");
            if (conditionElement != null) {
                ExpressionEvaluator evaluator = this.digestCondition(conditionElement);
                resourceConfig.getSelectorPath().setConditionEvaluator(evaluator);
            } else if (defaultConditionRef != null) {
                ExpressionEvaluator evaluator = this.getConditionEvaluator(defaultConditionRef);
                resourceConfig.getSelectorPath().setConditionEvaluator(evaluator);
            }
        }
        catch (ClassNotFoundException | IllegalArgumentException e) {
            throw new SmooksConfigException("Invalid unit definition.", e);
        }
        this.digestParameters(configElement, resourceConfig);
        this.resourceConfigSeq.add(resourceConfig);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Adding smooks-resource config from [" + this.resourceConfigSeq.getName() + "]: " + resourceConfig);
        }
    }

    protected void loadExtendedResourceConfig(Element configElement, String defaultProfile, String defaultConditionRef) {
        String configNamespace = configElement.getNamespaceURI();
        Smooks configDigester = this.getExtendedResourceConfigLoader(configNamespace);
        ExecutionContext executionContext = configDigester.createExecutionContext();
        Element conditionElement = DomUtils.getElement(configElement, "condition", 1);
        ExtensionContext extentionContext = conditionElement != null && conditionElement.getNamespaceURI().equals(XSD_V20) ? new ExtensionContext(this, defaultProfile, this.digestCondition(conditionElement)) : (defaultConditionRef != null ? new ExtensionContext(this, defaultProfile, this.getConditionEvaluator(defaultConditionRef)) : new ExtensionContext(this, defaultProfile, null));
        executionContext.put(ExtensionContext.EXTENSION_CONTEXT_TYPED_KEY, extentionContext);
        configDigester.filterSource(executionContext, new DOMSource(configElement), null);
        List<ResourceConfig> resourceConfigs = extentionContext.getResources();
        for (ResourceConfig resourceConfig : resourceConfigs) {
            this.resourceConfigSeq.add(resourceConfig);
        }
    }

    protected Smooks getExtendedResourceConfigLoader(String configNamespace) {
        Smooks smooks = this.extendedResourceConfigLoaders.get(configNamespace);
        if (smooks == null) {
            URI namespaceURI;
            try {
                namespaceURI = new URI(configNamespace);
            }
            catch (URISyntaxException e) {
                throw new SmooksConfigException("Unable to parse extended config namespace URI '" + configNamespace + "'.", e);
            }
            String resourcePath = String.format("/META-INF%s-smooks.xml", namespaceURI.getPath());
            File resourceFile = new File(resourcePath);
            String baseURI = resourceFile.getParent().replace('\\', '/');
            this.assertExtendedConfigOK(configNamespace, resourcePath);
            ApplicationContextBuilder applicationContextBuilder = ServiceLoader.load(ApplicationContextBuilder.class).iterator().next();
            if (applicationContextBuilder instanceof DefaultApplicationContextBuilder) {
                applicationContextBuilder = ((DefaultApplicationContextBuilder)applicationContextBuilder).withSystemResources(false);
            }
            smooks = new Smooks(applicationContextBuilder.withClassLoader(this.classLoader).build());
            XmlResourceConfigLoader.setExtensionDigestOn();
            try {
                Registry registry = smooks.getApplicationContext().getRegistry();
                DefaultResourceConfigSeq extensionResourceConfigSeq = new DefaultResourceConfigSeq(baseURI);
                XmlResourceConfigLoader xmlResourceConfigLoader = new XmlResourceConfigLoader(extensionResourceConfigSeq);
                xmlResourceConfigLoader.extendedResourceConfigLoaders = this.extendedResourceConfigLoaders;
                xmlResourceConfigLoader.loadConfigRecursively(new InputStreamReader(ClassUtils.getResourceAsStream(resourcePath, this.classLoader)), baseURI);
                registry.registerResourceConfigSeq(extensionResourceConfigSeq);
            }
            catch (Exception e) {
                throw new SmooksConfigException("Failed to construct Smooks instance for processing extended configuration resource '" + resourcePath + "'.", e);
            }
            finally {
                XmlResourceConfigLoader.setExtensionDigestOff();
            }
            this.extendedResourceConfigLoaders.put(configNamespace, smooks);
        }
        return smooks;
    }

    protected void assertExtendedConfigOK(String configNamespace, String resourcePath) {
        XsdDOMValidator validator;
        Document configDoc;
        InputStream resourceStream = ClassUtils.getResourceAsStream(resourcePath, this.classLoader);
        if (resourceStream == null) {
            throw new SmooksConfigException("Unable to locate Smooks digest configuration '" + resourcePath + "' for extended resource configuration namespace '" + configNamespace + "'.  This resource must be available on the classpath.");
        }
        try {
            configDoc = XmlUtils.parseStream(resourceStream);
        }
        catch (Exception e) {
            throw new SmooksConfigException("Unable to parse namespace URI '" + configNamespace + "'.", e);
        }
        try {
            validator = new XsdDOMValidator(configDoc);
        }
        catch (SAXException e) {
            throw new SmooksConfigException("Unable to create XsdDOMValidator instance for extended resource config '" + resourcePath + "'.", e);
        }
        String defaultNS = validator.getDefaultNamespace().toString();
        if (!XSD_V20.equals(defaultNS)) {
            throw new SmooksConfigException("Extended resource configuration '" + resourcePath + "' default namespace must be a valid Smooks configuration namespace.");
        }
    }

    protected static boolean isExtensionConfig() {
        return EXTENSION_DIGEST_ON.get();
    }

    protected static void setExtensionDigestOn() {
        EXTENSION_DIGEST_ON.set(true);
    }

    protected static void setExtensionDigestOff() {
        EXTENSION_DIGEST_ON.set(false);
    }

    protected void digestConditions(Element conditionsElement) {
        NodeList conditions = conditionsElement.getElementsByTagName("condition");
        for (int i = 0; i < conditions.getLength(); ++i) {
            Element conditionElement = (Element)conditions.item(i);
            String id = DomUtils.getAttributeValue(conditionElement, "id");
            if (id == null) continue;
            this.addConditionEvaluator(id, this.digestCondition(conditionElement));
        }
    }

    public ExpressionEvaluator digestCondition(Element conditionElement) throws SmooksConfigException {
        String idRef = DomUtils.getAttributeValue(conditionElement, "idRef");
        if (idRef != null) {
            return this.getConditionEvaluator(idRef);
        }
        String evaluatorClassName = DomUtils.getAttributeValue(conditionElement, "evaluator");
        String evaluatorConditionExpression = DomUtils.getAllText(conditionElement, true);
        if (evaluatorConditionExpression == null || evaluatorConditionExpression.trim().equals("")) {
            throw new SmooksConfigException("smooks-resource/condition must specify a condition expression as child text e.g. <condition evaluator=\"....\">A + B > C</condition>.");
        }
        return this.expressionEvaluatorFactory.create(evaluatorClassName, evaluatorConditionExpression);
    }

    protected void digestProfiles(Element profilesElement) {
        NodeList configNodes = profilesElement.getChildNodes();
        for (int i = 0; i < configNodes.getLength(); ++i) {
            if (configNodes.item(i).getNodeType() != 1) continue;
            Element profileNode = (Element)configNodes.item(i);
            String baseProfile = DomUtils.getAttributeValue(profileNode, "base-profile");
            String subProfiles = DomUtils.getAttributeValue(profileNode, "sub-profiles");
            DefaultProfileSet profileSet = new DefaultProfileSet(baseProfile);
            if (subProfiles != null) {
                profileSet.addProfiles(subProfiles.split(","));
            }
            this.resourceConfigSeq.add(profileSet);
        }
    }

    protected void digestParameters(Element resourceConfigElement, ResourceConfig resourceConfig) {
        NodeList configNodes = resourceConfigElement.getElementsByTagName("param");
        for (int i = 0; i < configNodes.getLength(); ++i) {
            Element paramNode = (Element)configNodes.item(i);
            String paramName = DomUtils.getAttributeValue(paramNode, "name");
            String paramType = DomUtils.getAttributeValue(paramNode, "type");
            String paramValue = DomUtils.getAllText(paramNode, true);
            Parameter<String> paramInstance = resourceConfig.setParameter(paramName, paramType, paramValue);
            paramInstance.setXml(paramNode);
        }
    }

    public String getCurrentPath() {
        StringBuilder pathBuilder = new StringBuilder();
        for (int i = this.configStack.size() - 1; i >= 0; --i) {
            pathBuilder.insert(0, "]");
            pathBuilder.insert(0, ((SmooksConfig)this.configStack.get(i)).configFile);
            pathBuilder.insert(0, "/[");
        }
        return pathBuilder.toString();
    }

    protected void pushConfig(String file, URI fileURI) {
        for (SmooksConfig smooksConfig : this.configStack) {
            if (!fileURI.equals(smooksConfig.fileURI)) continue;
            throw new SmooksConfigException("Invalid circular reference to config file '" + fileURI + "' from inside config file '" + this.getCurrentPath() + "'.");
        }
        SmooksConfig config = new SmooksConfig(file);
        config.parent = this.configStack.peek();
        config.fileURI = fileURI;
        this.configStack.push(config);
    }

    protected void popConfig() {
        this.configStack.pop();
    }

    public void addConditionEvaluator(String id, ExpressionEvaluator evaluator) {
        this.assertUniqueConditionId(id);
        this.configStack.peek().conditionEvaluators.put(id, evaluator);
    }

    public ExpressionEvaluator getConditionEvaluator(String idRef) {
        SmooksConfig smooksConfig = this.configStack.peek();
        while (smooksConfig != null) {
            ExpressionEvaluator evaluator = (ExpressionEvaluator)smooksConfig.conditionEvaluators.get(idRef);
            if (evaluator != null) {
                return evaluator;
            }
            smooksConfig = smooksConfig.parent;
        }
        throw new SmooksConfigException("Unknown condition idRef '" + idRef + "'.");
    }

    protected void assertUniqueConditionId(String id) {
        if (this.configStack.peek().conditionEvaluators.containsKey(id)) {
            throw new SmooksConfigException("Duplicate condition ID '" + id + "'.");
        }
    }

    protected static class SmooksConfig {
        private SmooksConfig parent;
        private final String configFile;
        private final Map<String, ExpressionEvaluator> conditionEvaluators = new HashMap<String, ExpressionEvaluator>();
        public URI fileURI;

        private SmooksConfig(String configFile) {
            this.configFile = configFile;
        }
    }
}

