/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config.loader.xml.extension;

import java.util.EmptyStackException;
import java.util.Optional;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.dom.DOMVisitBefore;
import org.smooks.engine.resource.config.loader.xml.extension.ExtensionContext;
import org.smooks.engine.resource.config.loader.xml.extension.ResourceConfigUtils;
import org.smooks.support.DomUtils;
import org.w3c.dom.Element;

public class MapToResourceConfigFromAttribute
implements DOMVisitBefore {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapToResourceConfigFromAttribute.class);
    @Inject
    private Optional<String> mapTo;
    @Inject
    private Optional<String> mapToSpecifier;
    @Inject
    private String attribute;
    @Inject
    private Optional<String> defaultValue;

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        ResourceConfig resourceConfig;
        String value = DomUtils.getAttributeValue(element, this.attribute);
        String actualMapTo = this.mapTo.orElse(null);
        if (actualMapTo == null && this.mapToSpecifier.isPresent()) {
            actualMapTo = DomUtils.getAttributeValue(element, this.mapToSpecifier.get());
        }
        if (actualMapTo == null) {
            actualMapTo = this.attribute;
        }
        try {
            resourceConfig = executionContext.get(ExtensionContext.EXTENSION_CONTEXT_TYPED_KEY).getResourceStack().peek();
        }
        catch (EmptyStackException e) {
            throw new SmooksException("No ResourceConfig available in ExtensionContext stack.  Unable to set ResourceConfig property '" + actualMapTo + "' with attribute '" + this.attribute + "' value '" + value + "'.");
        }
        if (value == null) {
            value = this.defaultValue.orElse(null);
        }
        if (value == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Not setting property '" + actualMapTo + "' on resource configuration.  Attribute '" + this.attribute + "' value on element '" + DomUtils.getName(element) + "' is null.  You may need to set a default value in the binding configuration.");
            }
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Setting property '" + actualMapTo + "' on resource configuration to a value of '" + value + "'.");
        }
        ResourceConfigUtils.setProperty(resourceConfig, actualMapTo, value, executionContext);
    }
}

