/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.reader;

import jakarta.annotation.PostConstruct;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ServiceLoader;
import javax.inject.Inject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.smooks.FilterSettings;
import org.smooks.Smooks;
import org.smooks.StreamFilterType;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ApplicationContextBuilder;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.api.resource.reader.SmooksXMLReader;
import org.smooks.engine.DefaultApplicationContextBuilder;
import org.smooks.engine.delivery.sax.ng.bridge.Bridge;
import org.smooks.engine.resource.config.SystemResourceConfigSeqFactory;
import org.smooks.io.DocumentInputSource;
import org.smooks.io.SAXWriter;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class DelegateReader
implements SmooksXMLReader {
    private final TypedKey<Writer> contentHandlerTypedKey = TypedKey.of();
    private final TypedKey<ExecutionContext> executionContextTypedKey = TypedKey.of();
    private ContentHandler contentHandler;
    private Smooks readerSmooks;
    private ErrorHandler errorHandler;
    private ExecutionContext executionContext;
    @Inject
    private ResourceConfig resourceConfig;
    @Inject
    private ApplicationContext applicationContext;
    private DocumentBuilder documentBuilder;

    @PostConstruct
    public void postConstruct() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/validation", false);
            this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SmooksException(e);
        }
        String smooksResourceList = "<smooks-resource-list xmlns=\"https://www.smooks.org/xsd/smooks-2.0.xsd\">" + this.resourceConfig.getParameter("resourceConfigs", String.class).getValue() + "</smooks-resource-list>";
        ResourceConfigSeq resourceConfigSeq = this.applicationContext.getResourceConfigLoader().load(new ByteArrayInputStream(smooksResourceList.getBytes(StandardCharsets.UTF_8)), "./", this.applicationContext.getClassLoader());
        ApplicationContextBuilder applicationContextBuilder = ServiceLoader.load(ApplicationContextBuilder.class).iterator().next();
        if (applicationContextBuilder instanceof DefaultApplicationContextBuilder) {
            applicationContextBuilder = ((DefaultApplicationContextBuilder)applicationContextBuilder).withSystemResources(false);
        }
        this.readerSmooks = new Smooks(applicationContextBuilder.withClassLoader(this.applicationContext.getClassLoader()).build());
        this.readerSmooks.setFilterSettings(new FilterSettings(StreamFilterType.SAX_NG).setCloseResult(false).setReaderPoolSize(-1));
        this.readerSmooks.getApplicationContext().getRegistry().registerResourceConfigSeq(new SystemResourceConfigSeqFactory("/nested-smooks-interceptors.xml", this.readerSmooks.getApplicationContext().getClassLoader(), this.applicationContext.getResourceLocator(), this.applicationContext.getResourceConfigLoader()).create());
        for (ResourceConfig resourceConfig : resourceConfigSeq) {
            this.readerSmooks.addResourceConfig(resourceConfig);
        }
    }

    @Override
    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setDTDHandler(DTDHandler dtdHandler) {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        Document document;
        if (inputSource instanceof DocumentInputSource) {
            document = ((DocumentInputSource)inputSource).getDocument();
        } else {
            document = this.documentBuilder.parse(inputSource);
            document.setStrictErrorChecking(false);
        }
        ExecutionContext readerExecutionContext = this.executionContext.get(this.executionContextTypedKey);
        if (readerExecutionContext == null) {
            readerExecutionContext = this.readerSmooks.createExecutionContext();
            this.executionContext.put(this.executionContextTypedKey, readerExecutionContext);
        }
        if (Bridge.isBridge(document.getFirstChild())) {
            Bridge bridge = new Bridge(document.getFirstChild());
            readerExecutionContext.put(bridge.getSourceKey(), bridge.getSourceValue(this.executionContext));
        }
        if (this.executionContext.get(this.contentHandlerTypedKey) == null) {
            this.executionContext.put(this.contentHandlerTypedKey, new SAXWriter(this.contentHandler, Charset.forName(this.executionContext.getContentEncoding())));
        }
        StreamResult streamResult = new StreamResult();
        streamResult.setWriter(this.executionContext.get(this.contentHandlerTypedKey));
        this.readerSmooks.filterSource(readerExecutionContext, new DOMSource(document), streamResult);
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
    }
}

