/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.visitor.smooks;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.smooks.FilterSettings;
import org.smooks.Smooks;
import org.smooks.StreamFilterType;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ApplicationContextBuilder;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.api.bean.repository.BeanId;
import org.smooks.api.delivery.event.ExecutionEventListener;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.delivery.ordering.Producer;
import org.smooks.api.lifecycle.PreExecutionLifecycle;
import org.smooks.api.memento.MementoCaretaker;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.api.resource.visitor.sax.ng.AfterVisitor;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.DefaultApplicationContextBuilder;
import org.smooks.engine.delivery.fragment.NodeFragment;
import org.smooks.engine.memento.SimpleVisitorMemento;
import org.smooks.engine.memento.VisitorMemento;
import org.smooks.engine.resource.config.DefaultResourceConfig;
import org.smooks.engine.resource.config.DefaultResourceConfigSeq;
import org.smooks.engine.resource.config.ParameterAccessor;
import org.smooks.engine.resource.config.SystemResourceConfigSeqFactory;
import org.smooks.engine.resource.visitor.dom.DOMModel;
import org.smooks.engine.resource.visitor.smooks.ChildEventListener;
import org.smooks.io.DomSerializer;
import org.smooks.io.FragmentWriter;
import org.smooks.io.ResourceWriter;
import org.smooks.io.Stream;
import org.smooks.support.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class NestedSmooksVisitor
implements BeforeVisitor,
AfterVisitor,
Producer,
PreExecutionLifecycle {
    protected static final TypedKey<Node> SOURCE_BRIDGE_TYPED_KEY = TypedKey.of();
    protected static final TypedKey<DocumentBuilder> CACHED_DOCUMENT_BUILDER_TYPED_KEY = TypedKey.of();
    protected static final TypedKey<ExecutionContext> NESTED_EXECUTION_CONTEXT_MEMENTO_TYPED_KEY = TypedKey.of();
    protected BeanId bindBeanId;
    protected Action action;
    @Inject
    @Named(value="action")
    protected Optional<Action> actionOptional;
    @Inject
    @Named(value="bindId")
    protected Optional<String> bindIdOptional;
    @Inject
    @Named(value="outputStreamResource")
    protected Optional<String> outputStreamResourceOptional;
    @Inject
    protected ResourceConfig resourceConfig;
    @Inject
    protected Integer maxNodeDepth = 1;
    @Inject
    protected ApplicationContext applicationContext;
    @Inject
    @Named(value="entities.rewrite")
    protected Boolean rewriteEntities = true;
    protected ResourceConfigSeq resourceConfigSeq;
    protected Smooks nestedSmooks;
    protected DomSerializer domSerializer;

    @PostConstruct
    public void postConstruct() throws SAXException, IOException, URISyntaxException, ClassNotFoundException {
        if (this.nestedSmooks == null) {
            if (!this.resourceConfig.getParameters("smooksResourceList").isEmpty()) {
                ByteArrayInputStream smooksResourceList = new ByteArrayInputStream(this.resourceConfig.getParameter("smooksResourceList", String.class).getValue().getBytes());
                this.resourceConfigSeq = this.applicationContext.getResourceConfigLoader().load(smooksResourceList, "./", this.applicationContext.getClassLoader());
            } else {
                DefaultResourceConfig resourceConfig = new DefaultResourceConfig("*", new Properties());
                resourceConfig.setResource("org.smooks.engine.delivery.sax.ng.SimpleSerializerVisitor");
                this.resourceConfigSeq = new DefaultResourceConfigSeq("./");
                this.resourceConfigSeq.add(resourceConfig);
            }
            ApplicationContextBuilder applicationContextBuilder = ServiceLoader.load(ApplicationContextBuilder.class).iterator().next();
            if (applicationContextBuilder instanceof DefaultApplicationContextBuilder) {
                applicationContextBuilder = ((DefaultApplicationContextBuilder)applicationContextBuilder).withSystemResources(false);
            }
            this.nestedSmooks = new Smooks(applicationContextBuilder.withClassLoader(this.applicationContext.getClassLoader()).withResourceLocator(this.applicationContext.getResourceLocator()).build());
            for (ResourceConfig resourceConfig : this.resourceConfigSeq) {
                this.nestedSmooks.addResourceConfig(resourceConfig);
            }
        }
        this.nestedSmooks.getApplicationContext().getRegistry().registerResourceConfigSeq(new SystemResourceConfigSeqFactory("/nested-smooks-interceptors.xml", this.nestedSmooks.getApplicationContext().getClassLoader(), this.nestedSmooks.getApplicationContext().getResourceLocator(), this.applicationContext.getResourceConfigLoader()).create());
        this.nestedSmooks.setFilterSettings(new FilterSettings(StreamFilterType.SAX_NG).setCloseResult(false).setReaderPoolSize(-1).setMaxNodeDepth(this.maxNodeDepth == 0 ? Integer.MAX_VALUE : this.maxNodeDepth));
        this.action = this.actionOptional.orElse(null);
        if (this.action != null) {
            if (this.action == Action.BIND_TO) {
                AssertArgument.isNotNull(this.bindIdOptional.orElse(null), "bindId");
                this.bindBeanId = this.applicationContext.getBeanIdStore().register(this.bindIdOptional.get());
            } else if (this.action == Action.OUTPUT_TO) {
                AssertArgument.isNotNull(this.outputStreamResourceOptional.orElse(null), "outputStreamResource");
            }
        }
        this.domSerializer = new DomSerializer(false, this.rewriteEntities);
    }

    @Override
    public void onPreExecution(ExecutionContext executionContext) {
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SmooksException(e);
        }
        executionContext.put(CACHED_DOCUMENT_BUILDER_TYPED_KEY, documentBuilder);
    }

    protected Node deAttach(Node node, ExecutionContext executionContext) {
        Document document = executionContext.get(CACHED_DOCUMENT_BUILDER_TYPED_KEY).newDocument();
        document.setStrictErrorChecking(false);
        Node copyNode = document.importNode(node, true);
        document.appendChild(copyNode);
        return copyNode;
    }

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) {
        Writer nodeWriter;
        Node rootNode = this.deAttach(element, executionContext);
        NodeFragment visitedFragment = new NodeFragment(element);
        executionContext.getMementoCaretaker().capture(new SimpleVisitorMemento<Node>(visitedFragment, (Visitor)this, rootNode));
        NodeFragment rootNodeFragment = new NodeFragment(rootNode);
        if (this.action == null) {
            this.filterSource(visitedFragment, rootNodeFragment, Stream.out(executionContext), executionContext, "visitBefore");
            nodeWriter = Stream.out(executionContext);
        } else if (this.action == Action.OUTPUT_TO) {
            ResourceWriter resourceWriter = new ResourceWriter(executionContext, this.outputStreamResourceOptional.get());
            if (resourceWriter.getDelegateWriter() == null) {
                this.filterSource(visitedFragment, rootNodeFragment, null, executionContext, "visitBefore");
                nodeWriter = null;
            } else {
                executionContext.getMementoCaretaker().capture(new SimpleVisitorMemento<ResourceWriter>(rootNodeFragment, (Visitor)this, resourceWriter));
                this.filterSource(visitedFragment, rootNodeFragment, resourceWriter, executionContext, "visitBefore");
                nodeWriter = resourceWriter.getDelegateWriter();
            }
        } else if (this.action == Action.PREPEND_BEFORE || this.action == Action.PREPEND_AFTER) {
            nodeWriter = this.prependBefore(visitedFragment, this.action, (Element)rootNodeFragment.unwrap(), executionContext);
        } else if (this.action == Action.APPEND_BEFORE || this.action == Action.APPEND_AFTER) {
            FragmentWriter fragmentWriter = new FragmentWriter(executionContext, rootNodeFragment);
            if (executionContext.getContentDeliveryRuntime().getContentDeliveryConfig().isDefaultSerializationOn()) {
                try {
                    this.domSerializer.writeStartElement(element, fragmentWriter);
                }
                catch (IOException e) {
                    throw new SmooksException(e);
                }
            }
            executionContext.getMementoCaretaker().capture(new SimpleVisitorMemento<FragmentWriter>(rootNodeFragment, (Visitor)this, fragmentWriter));
            this.filterSource(visitedFragment, rootNodeFragment, fragmentWriter, executionContext, "visitBefore");
            nodeWriter = fragmentWriter;
        } else if (this.action == Action.REPLACE) {
            nodeWriter = this.replaceBefore(visitedFragment, rootNodeFragment.unwrap(), executionContext);
        } else if (this.action == Action.BIND_TO) {
            nodeWriter = new StringWriter();
            executionContext.getMementoCaretaker().capture(new SimpleVisitorMemento<Writer>(rootNodeFragment, (Visitor)this, nodeWriter));
            this.filterSource(visitedFragment, rootNodeFragment, nodeWriter, executionContext, "visitBefore");
        } else {
            throw new UnsupportedOperationException();
        }
        ChildEventListener childEventListener = new ChildEventListener(this, nodeWriter, visitedFragment, executionContext);
        executionContext.getContentDeliveryRuntime().addExecutionEventListener(childEventListener);
        executionContext.getMementoCaretaker().capture(new SimpleVisitorMemento<ChildEventListener>(visitedFragment, (Visitor)this, childEventListener));
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) {
        NodeFragment visitedFragment = new NodeFragment(element);
        SimpleVisitorMemento<Element> rootNodeMemento = new SimpleVisitorMemento<Element>(visitedFragment, (Visitor)this, element);
        executionContext.getMementoCaretaker().restore(rootNodeMemento);
        NodeFragment rootNodeFragment = new NodeFragment((Node)rootNodeMemento.getState());
        if (this.action == null) {
            this.filterSource(visitedFragment, rootNodeFragment, Stream.out(executionContext), executionContext, "visitAfter");
        } else if (this.action == Action.OUTPUT_TO) {
            ResourceWriter resourceWriter = (ResourceWriter)executionContext.getMementoCaretaker().stash(new SimpleVisitorMemento<ResourceWriter>(rootNodeFragment, (Visitor)this, new ResourceWriter(executionContext, this.outputStreamResourceOptional.get())), resourceWriterMemento -> resourceWriterMemento).getState();
            this.filterSource(visitedFragment, rootNodeFragment, resourceWriter, executionContext, "visitAfter");
        } else if (this.action == Action.APPEND_BEFORE || this.action == Action.APPEND_AFTER) {
            this.append(visitedFragment, (Element)rootNodeFragment.unwrap(), this.action, executionContext);
        } else if (this.action == Action.PREPEND_BEFORE || this.action == Action.PREPEND_AFTER) {
            this.prependAfter(visitedFragment, (Element)rootNodeFragment.unwrap(), executionContext);
        } else if (this.action == Action.REPLACE) {
            this.replaceAfter(visitedFragment, rootNodeFragment.unwrap(), executionContext);
        } else if (this.action == Action.BIND_TO) {
            SimpleVisitorMemento<StringWriter> memento = new SimpleVisitorMemento<StringWriter>(rootNodeFragment, (Visitor)this, new StringWriter());
            executionContext.getMementoCaretaker().restore(memento);
            this.filterSource(visitedFragment, rootNodeFragment, (Writer)memento.getState(), executionContext, "visitAfter");
            executionContext.getBeanContext().addBean(this.bindBeanId, (Object)((StringWriter)memento.getState()).toString(), rootNodeFragment);
        } else {
            throw new UnsupportedOperationException();
        }
        SimpleVisitorMemento<ChildEventListener> childEventListenerMemento = new SimpleVisitorMemento<ChildEventListener>(visitedFragment, (Visitor)this, new ChildEventListener(this, null, null, null));
        executionContext.getMementoCaretaker().restore(childEventListenerMemento);
        executionContext.getContentDeliveryRuntime().removeExecutionEventListener((ExecutionEventListener)childEventListenerMemento.getState());
    }

    protected Writer replaceBefore(Fragment<Node> visitedNodeFragment, Node rootNode, ExecutionContext executionContext) {
        NodeFragment rootNodeFragment = new NodeFragment(rootNode, true);
        FragmentWriter fragmentWriter = new FragmentWriter(executionContext, rootNodeFragment, false);
        try {
            fragmentWriter.park();
        }
        catch (IOException e) {
            throw new SmooksException(e);
        }
        executionContext.getMementoCaretaker().capture(new SimpleVisitorMemento<FragmentWriter>(rootNodeFragment, (Visitor)this, fragmentWriter));
        this.filterSource(visitedNodeFragment, rootNodeFragment, fragmentWriter, executionContext, "visitBefore");
        return fragmentWriter;
    }

    protected void replaceAfter(Fragment<Node> visitedNodeFragment, Node rootNode, ExecutionContext executionContext) {
        NodeFragment rootNodeFragment = new NodeFragment(rootNode);
        SimpleVisitorMemento<FragmentWriter> fragmentWriterVisitorMemento = new SimpleVisitorMemento<FragmentWriter>(rootNodeFragment, (Visitor)this, new FragmentWriter(executionContext, new NodeFragment(rootNode)));
        executionContext.getMementoCaretaker().restore(fragmentWriterVisitorMemento);
        this.filterSource(visitedNodeFragment, rootNodeFragment, (Writer)fragmentWriterVisitorMemento.getState(), executionContext, "visitAfter");
    }

    protected Writer prependBefore(Fragment<Node> visitedNodeFragment, Action action, Element rootElement, ExecutionContext executionContext) {
        NodeFragment rootNodeFragment = new NodeFragment(rootElement, true);
        FragmentWriter fragmentWriter = new FragmentWriter(executionContext, rootNodeFragment, false);
        try {
            fragmentWriter.park();
            if (executionContext.getContentDeliveryRuntime().getContentDeliveryConfig().isDefaultSerializationOn() && action == Action.PREPEND_AFTER) {
                this.domSerializer.writeStartElement(rootElement, fragmentWriter);
            }
            executionContext.getMementoCaretaker().capture(new SimpleVisitorMemento<FragmentWriter>(rootNodeFragment, (Visitor)this, fragmentWriter));
            this.filterSource(visitedNodeFragment, rootNodeFragment, fragmentWriter, executionContext, "visitBefore");
        }
        catch (IOException e) {
            throw new SmooksException(e);
        }
        return fragmentWriter;
    }

    protected void prependAfter(Fragment<Node> visitedNodeFragment, Element rootElement, ExecutionContext executionContext) {
        NodeFragment rootNodeFragment = new NodeFragment(rootElement);
        SimpleVisitorMemento<FragmentWriter> fragmentWriterMemento = new SimpleVisitorMemento<FragmentWriter>(rootNodeFragment, (Visitor)this, new FragmentWriter(executionContext, rootNodeFragment));
        executionContext.getMementoCaretaker().restore(fragmentWriterMemento);
        this.filterSource(visitedNodeFragment, rootNodeFragment, (Writer)fragmentWriterMemento.getState(), executionContext, "visitAfter");
        try {
            if (executionContext.getContentDeliveryRuntime().getContentDeliveryConfig().isDefaultSerializationOn() && this.action == Action.PREPEND_BEFORE) {
                this.domSerializer.writeStartElement(rootElement, (Writer)fragmentWriterMemento.getState());
            }
            if (executionContext.getContentDeliveryRuntime().getContentDeliveryConfig().isDefaultSerializationOn()) {
                ((FragmentWriter)fragmentWriterMemento.getState()).write(XmlUtils.serialize(rootElement.getChildNodes(), Boolean.parseBoolean(ParameterAccessor.getParameterValue("close.empty.elements", String.class, "false", executionContext.getContentDeliveryRuntime().getContentDeliveryConfig()))));
                this.domSerializer.writeEndElement(rootElement, (Writer)fragmentWriterMemento.getState());
            }
        }
        catch (IOException e) {
            throw new SmooksException(e);
        }
    }

    protected void append(Fragment<Node> visitedNodeFragment, Element rootElement, Action action, ExecutionContext executionContext) {
        NodeFragment rootNodeFragment = new NodeFragment(rootElement);
        SimpleVisitorMemento<FragmentWriter> fragmentWriterMemento = new SimpleVisitorMemento<FragmentWriter>(rootNodeFragment, (Visitor)this, new FragmentWriter(executionContext, rootNodeFragment));
        executionContext.getMementoCaretaker().restore(fragmentWriterMemento);
        try {
            if (executionContext.getContentDeliveryRuntime().getContentDeliveryConfig().isDefaultSerializationOn() && action == Action.APPEND_AFTER) {
                this.domSerializer.writeEndElement(rootElement, (Writer)fragmentWriterMemento.getState());
            }
            this.filterSource(visitedNodeFragment, rootNodeFragment, (Writer)fragmentWriterMemento.getState(), executionContext, "visitAfter");
            if (executionContext.getContentDeliveryRuntime().getContentDeliveryConfig().isDefaultSerializationOn() && action == Action.APPEND_BEFORE) {
                this.domSerializer.writeEndElement(rootElement, (Writer)fragmentWriterMemento.getState());
            }
        }
        catch (IOException e) {
            throw new SmooksException(e);
        }
    }

    protected void filterSource(Fragment<Node> visitedNodeFragment, Fragment<Node> rootNodeFragment, Writer writer, ExecutionContext executionContext, String visit) {
        VisitorMemento<Object> nestedExecutionContextMemento;
        MementoCaretaker mementoCaretaker = executionContext.getMementoCaretaker();
        if (mementoCaretaker.exists(new VisitorMemento(visitedNodeFragment, this, NESTED_EXECUTION_CONTEXT_MEMENTO_TYPED_KEY))) {
            nestedExecutionContextMemento = new VisitorMemento(visitedNodeFragment, this, NESTED_EXECUTION_CONTEXT_MEMENTO_TYPED_KEY);
            mementoCaretaker.restore(nestedExecutionContextMemento);
        } else {
            ExecutionContext nestedExecutionContext = this.nestedSmooks.createExecutionContext();
            nestedExecutionContext.setContentEncoding(executionContext.getContentEncoding());
            nestedExecutionContext.setBeanContext(executionContext.getBeanContext().newSubContext(nestedExecutionContext));
            nestedExecutionContext.put(DOMModel.DOM_MODEL_TYPED_KEY, DOMModel.getModel(executionContext));
            nestedExecutionContextMemento = new VisitorMemento<ExecutionContext>(visitedNodeFragment, this, NESTED_EXECUTION_CONTEXT_MEMENTO_TYPED_KEY, nestedExecutionContext);
            mementoCaretaker.capture(nestedExecutionContextMemento);
        }
        Document document = executionContext.get(CACHED_DOCUMENT_BUILDER_TYPED_KEY).newDocument();
        document.setStrictErrorChecking(false);
        Element smooksBridgeElement = document.createElementNS("https://www.smooks.org", "bridge");
        smooksBridgeElement.setAttribute("visit", visit);
        smooksBridgeElement.setAttribute("source", SOURCE_BRIDGE_TYPED_KEY.getName());
        document.appendChild(smooksBridgeElement);
        ((ExecutionContext)nestedExecutionContextMemento.getState()).put(SOURCE_BRIDGE_TYPED_KEY, rootNodeFragment.unwrap());
        if (writer == null) {
            this.nestedSmooks.filterSource((ExecutionContext)nestedExecutionContextMemento.getState(), new DOMSource(document), new Result[0]);
        } else {
            this.nestedSmooks.filterSource((ExecutionContext)nestedExecutionContextMemento.getState(), new DOMSource(document), new StreamResult(writer));
        }
    }

    public int getMaxNodeDepth() {
        if (this.action != null && (this.action.equals((Object)Action.PREPEND_BEFORE) || this.action.equals((Object)Action.PREPEND_AFTER))) {
            return Integer.MAX_VALUE;
        }
        return this.maxNodeDepth == 0 ? Integer.MAX_VALUE : this.maxNodeDepth;
    }

    public Set<String> getProducts() {
        return this.outputStreamResourceOptional.map(os -> java.util.stream.Stream.of(os).collect(Collectors.toSet())).orElse(Collections.EMPTY_SET);
    }

    public void setMaxNodeDepth(Integer maxNodeDepth) {
        this.maxNodeDepth = maxNodeDepth;
    }

    public Smooks getNestedSmooks() {
        return this.nestedSmooks;
    }

    public void setNestedSmooks(Smooks nestedSmooks) {
        this.nestedSmooks = nestedSmooks;
    }

    public void setResourceConfig(ResourceConfig resourceConfig) {
        this.resourceConfig = resourceConfig;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setResourceConfigSeq(ResourceConfigSeq resourceConfigSeq) {
        this.resourceConfigSeq = resourceConfigSeq;
    }

    public void setAction(Optional<Action> actionOptional) {
        this.actionOptional = actionOptional;
    }

    public void setBindIdOptional(Optional<String> bindIdOptional) {
        this.bindIdOptional = bindIdOptional;
    }

    public Optional<String> getOutputStreamResourceOptional() {
        return this.outputStreamResourceOptional;
    }

    public void setOutputStreamResourceOptional(Optional<String> outputStreamResourceOptional) {
        this.outputStreamResourceOptional = outputStreamResourceOptional;
    }

    @PreDestroy
    public void preDestroy() {
        if (this.nestedSmooks != null) {
            this.nestedSmooks.close();
        }
    }

    public static enum Action {
        REPLACE,
        PREPEND_BEFORE,
        PREPEND_AFTER,
        APPEND_BEFORE,
        APPEND_AFTER,
        BIND_TO,
        OUTPUT_TO;

    }
}

