/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.io.AbstractOutputStreamResource;

public class ResourceWriter
extends Writer {
    private final String resourceName;
    private Writer delegateWriter;

    public ResourceWriter(ExecutionContext executionContext, String resourceName) {
        this.resourceName = resourceName;
        this.delegateWriter = this.getOutputWriter(resourceName, executionContext);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.delegateWriter == null) {
            throw new SmooksException("OutputResource '" + this.resourceName + "' not bound to context.  Configure an '" + AbstractOutputStreamResource.class.getName() + "' implementation, or change resource ordering.");
        }
        this.delegateWriter.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        if (this.delegateWriter != null) {
            this.delegateWriter.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.delegateWriter != null) {
            this.delegateWriter.close();
        }
    }

    protected Writer getOutputWriter(String resourceName, ExecutionContext executionContext) throws SmooksException {
        TypedKey resourceKey = TypedKey.of(AbstractOutputStreamResource.OUTPUTSTREAM_CONTEXT_KEY_PREFIX + resourceName);
        Object resourceIOObj = executionContext.get(resourceKey);
        if (resourceIOObj == null) {
            AbstractOutputStreamResource resource = (AbstractOutputStreamResource)executionContext.get(TypedKey.of(AbstractOutputStreamResource.RESOURCE_CONTEXT_KEY_PREFIX + resourceName));
            OutputStream outputStream = this.openOutputStream(resource, executionContext);
            if (outputStream != null) {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, resource.getWriterEncoding());
                executionContext.put(resourceKey, outputStreamWriter);
                return outputStreamWriter;
            }
            return null;
        }
        if (resourceIOObj instanceof Writer) {
            return (Writer)resourceIOObj;
        }
        if (resourceIOObj instanceof OutputStream) {
            throw new SmooksException("An OutputStream to the '" + resourceName + "' resource is already open.  Cannot open a Writer to this resource now!");
        }
        throw new RuntimeException("Invalid runtime ExecutionContext state. Value stored under context key '" + resourceKey + "' must be either and OutputStream or Writer.  Is '" + resourceIOObj.getClass().getName() + "'.");
    }

    protected OutputStream openOutputStream(AbstractOutputStreamResource resource, ExecutionContext executionContext) {
        if (resource != null) {
            try {
                return resource.getOutputStream(executionContext);
            }
            catch (IOException e) {
                throw new SmooksException("Unable to set outputstream for '" + resource.getResourceName() + "'.", e);
            }
        }
        return null;
    }

    public Writer getDelegateWriter() {
        return this.delegateWriter;
    }
}

