/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smooks.converter;

import java.io.File;
import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.WrappedFile;
import org.smooks.io.payload.JavaResult;
import org.smooks.io.payload.JavaSource;
import org.smooks.io.payload.JavaSourceWithoutEventStream;

@Converter(generateLoader=true)
public class SourceConverter {
    private SourceConverter() {
    }

    @Converter
    public static JavaSourceWithoutEventStream toJavaSourceWithoutEventStream(Object payload) {
        return new JavaSourceWithoutEventStream(payload);
    }

    @Converter
    public static JavaSource toJavaSource(Object payload) {
        return new JavaSource(payload);
    }

    @Converter
    public static Source toStreamSource(InputStream in) {
        return new StreamSource(in);
    }

    @Converter
    public static JavaSource toJavaSource(JavaResult result) {
        return new JavaSource(result.getResultMap().values());
    }

    @Converter(allowNull=true)
    public static Source toStreamSource(WrappedFile<?> file, Exchange exchange) throws Exception {
        Object obj = file.getFile();
        if (obj instanceof File) {
            File f = (File)obj;
            return new StreamSource(f);
        }
        InputStream is = exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, file.getBody());
        return new StreamSource(is);
    }
}

