/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine;

import java.util.ServiceLoader;
import org.smooks.api.ApplicationContext;
import org.smooks.api.ApplicationContextBuilder;
import org.smooks.api.Registry;
import org.smooks.api.delivery.ContentDeliveryRuntimeFactory;
import org.smooks.api.delivery.ContentHandlerFactory;
import org.smooks.api.delivery.ReaderPoolFactory;
import org.smooks.api.lifecycle.LifecyclePhase;
import org.smooks.api.profile.Profile;
import org.smooks.api.resource.ContainerResourceLocator;
import org.smooks.api.resource.config.loader.ResourceConfigLoader;
import org.smooks.engine.DefaultApplicationContext;
import org.smooks.engine.DefaultRegistry;
import org.smooks.engine.delivery.DefaultContentDeliveryRuntimeFactory;
import org.smooks.engine.delivery.DefaultReaderPoolFactory;
import org.smooks.engine.injector.Scope;
import org.smooks.engine.lifecycle.PostConstructLifecyclePhase;
import org.smooks.engine.lookup.LifecycleManagerLookup;
import org.smooks.engine.profile.DefaultProfileSet;
import org.smooks.engine.resource.config.SystemResourceConfigSeqFactory;
import org.smooks.engine.resource.config.loader.xml.XmlResourceConfigLoader;
import org.smooks.io.payload.Exports;
import org.smooks.resource.URIResourceLocator;

public class DefaultApplicationContextBuilder
implements ApplicationContextBuilder {
    private boolean systemResources = true;
    private ClassLoader classLoader = this.getClass().getClassLoader();
    private Registry registry;
    private ContentDeliveryRuntimeFactory contentDeliveryRuntimeFactory;
    private ContainerResourceLocator resourceLocator = new URIResourceLocator();
    private ResourceConfigLoader resourceConfigLoader = new XmlResourceConfigLoader();
    private ReaderPoolFactory readerPoolFactory = new DefaultReaderPoolFactory();

    public DefaultApplicationContextBuilder() {
    }

    protected DefaultApplicationContextBuilder(boolean systemResources, ClassLoader classLoader, Registry registry, ContentDeliveryRuntimeFactory contentDeliveryRuntimeFactory, ContainerResourceLocator resourceLocator, ResourceConfigLoader resourceConfigLoader, ReaderPoolFactory readerPoolFactory) {
        this.systemResources = systemResources;
        this.classLoader = classLoader;
        this.registry = registry;
        this.contentDeliveryRuntimeFactory = contentDeliveryRuntimeFactory;
        this.resourceLocator = resourceLocator;
        this.resourceConfigLoader = resourceConfigLoader;
        this.readerPoolFactory = readerPoolFactory;
    }

    @Override
    public DefaultApplicationContextBuilder withClassLoader(ClassLoader classLoader) {
        return new DefaultApplicationContextBuilder(this.systemResources, classLoader, this.registry, this.contentDeliveryRuntimeFactory, this.resourceLocator, this.resourceConfigLoader, this.readerPoolFactory);
    }

    public DefaultApplicationContextBuilder withSystemResources(boolean systemResources) {
        return new DefaultApplicationContextBuilder(systemResources, this.classLoader, this.registry, this.contentDeliveryRuntimeFactory, this.resourceLocator, this.resourceConfigLoader, this.readerPoolFactory);
    }

    @Override
    public DefaultApplicationContextBuilder withRegistry(Registry registry) {
        return new DefaultApplicationContextBuilder(this.systemResources, this.classLoader, registry, this.contentDeliveryRuntimeFactory, this.resourceLocator, this.resourceConfigLoader, this.readerPoolFactory);
    }

    @Override
    public DefaultApplicationContextBuilder withContentDeliveryRuntimeFactory(ContentDeliveryRuntimeFactory contentDeliveryRuntimeFactory) {
        return new DefaultApplicationContextBuilder(this.systemResources, this.classLoader, this.registry, contentDeliveryRuntimeFactory, this.resourceLocator, this.resourceConfigLoader, this.readerPoolFactory);
    }

    @Override
    public DefaultApplicationContextBuilder withResourceLocator(ContainerResourceLocator resourceLocator) {
        return new DefaultApplicationContextBuilder(this.systemResources, this.classLoader, this.registry, this.contentDeliveryRuntimeFactory, resourceLocator, this.resourceConfigLoader, this.readerPoolFactory);
    }

    @Override
    public DefaultApplicationContextBuilder withResourceConfigLoader(ResourceConfigLoader resourceConfigLoader) {
        return new DefaultApplicationContextBuilder(this.systemResources, this.classLoader, this.registry, this.contentDeliveryRuntimeFactory, this.resourceLocator, resourceConfigLoader, this.readerPoolFactory);
    }

    @Override
    public DefaultApplicationContextBuilder withReaderPoolFactory(ReaderPoolFactory readerPoolFactory) {
        return new DefaultApplicationContextBuilder(this.systemResources, this.classLoader, this.registry, this.contentDeliveryRuntimeFactory, this.resourceLocator, this.resourceConfigLoader, readerPoolFactory);
    }

    @Override
    public ApplicationContext build() {
        DefaultApplicationContext applicationContext = new DefaultApplicationContext();
        applicationContext.setClassLoader(this.classLoader);
        applicationContext.setResourceConfigLoader(this.resourceConfigLoader);
        applicationContext.setReaderPoolFactory(this.readerPoolFactory);
        applicationContext.setResourceLocator(this.resourceLocator);
        Registry applicationContextRegistry = this.registry == null ? new DefaultRegistry(applicationContext.getClassLoader(), applicationContext.getResourceConfigLoader(), applicationContext.getProfileStore()) : this.registry;
        this.initRegistry(applicationContext, applicationContextRegistry);
        applicationContext.setRegistry(applicationContextRegistry);
        if (this.contentDeliveryRuntimeFactory == null) {
            applicationContext.setContentDeliveryRuntimeFactory(new DefaultContentDeliveryRuntimeFactory(applicationContext.getRegistry(), applicationContext.getReaderPoolFactory()));
        } else {
            applicationContext.setContentDeliveryRuntimeFactory(this.contentDeliveryRuntimeFactory);
        }
        applicationContext.getProfileStore().addProfileSet(new DefaultProfileSet(Profile.DEFAULT_PROFILE));
        return applicationContext;
    }

    protected void initRegistry(ApplicationContext applicationContext, Registry registry) {
        registry.registerObject(ApplicationContext.class, applicationContext);
        registry.registerObject(Exports.class, new Exports());
        this.registerSystemContentHandlerFactories(registry);
        if (this.systemResources) {
            this.registerSystemResources(registry, applicationContext);
        }
    }

    protected void registerSystemContentHandlerFactories(Registry registry) {
        for (ContentHandlerFactory contentHandlerFactory : ServiceLoader.load(ContentHandlerFactory.class, this.classLoader)) {
            registry.lookup(new LifecycleManagerLookup()).applyPhase(contentHandlerFactory, (LifecyclePhase)new PostConstructLifecyclePhase(new Scope(registry)));
            registry.registerObject(contentHandlerFactory);
        }
    }

    protected void registerSystemResources(Registry registry, ApplicationContext applicationContext) {
        registry.registerResourceConfigSeq(new SystemResourceConfigSeqFactory("/null-dom.xml", registry.getClassLoader(), applicationContext.getResourceLocator(), applicationContext.getResourceConfigLoader()).create());
        registry.registerResourceConfigSeq(new SystemResourceConfigSeqFactory("/null-sax.xml", registry.getClassLoader(), applicationContext.getResourceLocator(), applicationContext.getResourceConfigLoader()).create());
        registry.registerResourceConfigSeq(new SystemResourceConfigSeqFactory("/system-param-decoders.xml", registry.getClassLoader(), applicationContext.getResourceLocator(), applicationContext.getResourceConfigLoader()).create());
        registry.registerResourceConfigSeq(new SystemResourceConfigSeqFactory("/system-serializers.xml", registry.getClassLoader(), applicationContext.getResourceLocator(), applicationContext.getResourceConfigLoader()).create());
        registry.registerResourceConfigSeq(new SystemResourceConfigSeqFactory("/system-interceptors.xml", registry.getClassLoader(), applicationContext.getResourceLocator(), applicationContext.getResourceConfigLoader()).create());
    }
}

