/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;

public class BinaryConverterFactory
implements TypeConverterFactory<String, String> {
    private static final Pattern BINARY_PATTERN = Pattern.compile("^[01]+$");

    @Override
    public TypeConverter<String, String> createTypeConverter() {
        return value -> {
            Matcher binaryMatcher = BINARY_PATTERN.matcher((CharSequence)value);
            if (binaryMatcher.matches()) {
                return value;
            }
            throw new TypeConverterException("Failed to decode binary sequence '" + value + "'.");
        };
    }

    @Override
    public TypeConverterDescriptor<Class<String>, Class<String>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<String>>(String.class, String.class);
    }
}

