/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;

public class CharsetConverterFactory
implements TypeConverterFactory<String, Charset> {
    @Override
    public TypeConverter<String, Charset> createTypeConverter() {
        return value -> {
            try {
                return Charset.forName(value);
            }
            catch (UnsupportedCharsetException e) {
                throw new TypeConverterException("Unsupported character set '" + value + "'.");
            }
        };
    }

    @Override
    public TypeConverterDescriptor<Class<String>, Class<Charset>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<Charset>>(String.class, Charset.class);
    }
}

