/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.converter;

import java.net.URI;
import java.net.URISyntaxException;
import org.smooks.api.converter.TypeConverter;
import org.smooks.api.converter.TypeConverterDescriptor;
import org.smooks.api.converter.TypeConverterException;
import org.smooks.api.converter.TypeConverterFactory;
import org.smooks.engine.converter.DefaultTypeConverterDescriptor;

public class URIConverterFactory
implements TypeConverterFactory<String, URI> {
    @Override
    public TypeConverter<String, URI> createTypeConverter() {
        return value -> {
            try {
                return new URI(value.trim());
            }
            catch (URISyntaxException e) {
                throw new TypeConverterException("Failed to decode URI value '" + value + "'.", e);
            }
        };
    }

    @Override
    public TypeConverterDescriptor<Class<String>, Class<URI>> getTypeConverterDescriptor() {
        return new DefaultTypeConverterDescriptor<Class<String>, Class<URI>>(String.class, URI.class);
    }
}

