/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.delivery.sax.ng;

import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.io.Writer;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.resource.visitor.SerializerVisitor;
import org.smooks.api.resource.visitor.sax.ng.ElementVisitor;
import org.smooks.io.DomSerializer;
import org.smooks.io.Stream;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;

public class SimpleSerializerVisitor
implements SerializerVisitor,
ElementVisitor {
    protected DomSerializer domSerializer;
    protected Boolean rewriteEntities = true;

    @PostConstruct
    public void postConstruct() {
        this.domSerializer = new DomSerializer(false, this.rewriteEntities);
    }

    @Inject
    public void setRewriteEntities(@Named(value="entities.rewrite") Optional<Boolean> rewriteEntities) {
        this.rewriteEntities = rewriteEntities.orElse(this.rewriteEntities);
    }

    @Override
    public void writeStartElement(Element element, Writer writer, ExecutionContext executionContext) throws IOException {
        this.domSerializer.writeStartElement(element, writer);
    }

    @Override
    public void writeEndElement(Element element, Writer writer, ExecutionContext executionContext) throws IOException {
        this.domSerializer.writeEndElement(element, writer);
    }

    @Override
    public void writeCharacterData(Node node, Writer writer, ExecutionContext executionContext) throws IOException {
        this.domSerializer.writeCharacterData(node, writer);
    }

    @Override
    public void writeElementComment(Comment comment, Writer writer, ExecutionContext executionContext) throws IOException {
        this.domSerializer.writeElementComment(comment, writer);
    }

    @Override
    public void writeElementEntityRef(EntityReference entityRef, Writer writer, ExecutionContext executionContext) throws IOException {
        this.domSerializer.writeElementEntityRef(entityRef, writer);
    }

    @Override
    public void writeElementCDATA(CDATASection cdata, Writer writer, ExecutionContext executionContext) throws IOException {
        this.domSerializer.writeElementCDATA(cdata, writer);
    }

    @Override
    public void writeElementNode(Node node, Writer writer, ExecutionContext executionContext) throws IOException {
        throw new IOException("writeElementNode not implemented yet. Node: " + node.getNodeValue() + ", node: [" + node + "]");
    }

    @Override
    public boolean writeChildElements() {
        return true;
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) {
        try {
            this.writeEndElement(element, Stream.out(executionContext), executionContext);
        }
        catch (IOException e) {
            throw new SmooksException(e);
        }
    }

    @Override
    public void visitChildText(CharacterData characterData, ExecutionContext executionContext) {
        try {
            this.writeCharacterData(characterData, Stream.out(executionContext), executionContext);
        }
        catch (IOException e) {
            throw new SmooksException(e);
        }
    }

    @Override
    public void visitChildElement(Element childElement, ExecutionContext executionContext) {
    }

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) {
        try {
            this.writeStartElement(element, Stream.out(executionContext), executionContext);
        }
        catch (IOException e) {
            throw new SmooksException(e);
        }
    }
}

