/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.lookup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.smooks.api.Registry;
import org.smooks.api.profile.ProfileSet;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.config.ResourceConfigSeq;
import org.smooks.engine.lookup.ResourceConfigSeqsLookup;

public class ResourceConfigsProfileSetLookup
implements Function<Map<Object, Object>, ResourceConfig[]> {
    private final Registry registry;
    private final ProfileSet profileSet;

    public ResourceConfigsProfileSetLookup(Registry registry, ProfileSet profileSet) {
        this.registry = registry;
        this.profileSet = profileSet;
    }

    @Override
    public ResourceConfig[] apply(Map<Object, Object> registryEntries) {
        ArrayList<ResourceConfig> profileSetResourceConfigs = new ArrayList<ResourceConfig>();
        for (ResourceConfigSeq resourceConfigSeq : this.registry.lookup(new ResourceConfigSeqsLookup())) {
            List<ResourceConfig> resourceConfigs = resourceConfigSeq.getAll(this.profileSet);
            profileSetResourceConfigs.addAll(resourceConfigs);
        }
        return profileSetResourceConfigs.toArray(new ResourceConfig[0]);
    }
}

