/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.memento;

import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.memento.Memento;
import org.smooks.api.resource.visitor.Visitor;
import org.smooks.assertion.AssertArgument;

public abstract class AbstractVisitorMemento
implements Memento {
    protected final Fragment<?> fragment;
    protected final Visitor visitor;
    protected String anchor;

    public AbstractVisitorMemento(Fragment<?> fragment, Visitor visitor) {
        AssertArgument.isNotNull(fragment, "fragment");
        AssertArgument.isNotNull(visitor, "visitor");
        this.fragment = fragment;
        this.visitor = visitor;
    }

    public Visitor getVisitor() {
        return this.visitor;
    }

    @Override
    public Fragment<?> getFragment() {
        return this.fragment;
    }

    @Override
    public String getAnchor() {
        if (this.anchor == null) {
            this.anchor = this.fragment.getId() + "@" + this.visitor.getClass().getName() + "@" + this.getClass().getName() + "@" + System.identityHashCode(this.visitor);
        }
        return this.anchor;
    }
}

