/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.profile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.smooks.api.profile.Profile;
import org.smooks.api.profile.ProfileSet;
import org.smooks.api.profile.ProfileStore;
import org.smooks.api.profile.UnknownProfileMemberException;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.profile.DefaultProfileSet;

public class DefaultProfileStore
implements ProfileStore {
    private final Map<String, ProfileSet> store = new ConcurrentHashMap<String, ProfileSet>();

    @Override
    public ProfileSet getProfileSet(String profileMember) throws UnknownProfileMemberException {
        this.assertProfileMemberNameOK(profileMember);
        ProfileSet set = this.store.get(profileMember.trim());
        if (set == null) {
            throw new UnknownProfileMemberException("Failed to get ProfileSet.  Unknown profile member name [" + profileMember + "]");
        }
        return set;
    }

    @Override
    public void addProfileSet(ProfileSet profileSet) {
        AssertArgument.isNotNull(profileSet, "profileSet");
        this.assertProfileMemberNameOK(profileSet.getBaseProfile());
        if (profileSet == null) {
            throw new IllegalArgumentException("null 'profileSet' arg in method call.");
        }
        if (!(profileSet instanceof DefaultProfileSet)) {
            throw new IllegalArgumentException("'profileSet' arg must be an instanceof DefaultProfileSet.");
        }
        this.store.put(profileSet.getBaseProfile().trim(), profileSet);
        this.expandProfiles();
    }

    public void expandProfiles() {
        for (Map.Entry<String, ProfileSet> profileSetEntry : this.store.entrySet()) {
            DefaultProfileSet profileSet = (DefaultProfileSet)profileSetEntry.getValue();
            Iterator iterator = profileSet.values().iterator();
            ArrayList<DefaultProfileSet> addOns = new ArrayList<DefaultProfileSet>();
            while (iterator.hasNext()) {
                Profile profile = (Profile)iterator.next();
                try {
                    DefaultProfileSet addOnProfileSet = (DefaultProfileSet)this.getProfileSet(profile.getName());
                    if (addOnProfileSet == null) continue;
                    addOns.add(addOnProfileSet);
                }
                catch (UnknownProfileMemberException addOnProfileSet) {}
            }
            for (DefaultProfileSet addOn : addOns) {
                profileSet.addProfileSet(addOn);
            }
        }
    }

    private void assertProfileMemberNameOK(String profileMember) throws IllegalArgumentException {
        AssertArgument.isNotNullAndNotEmpty(profileMember, "profileMember");
    }

    public String toString() {
        StringBuilder storeDescription = new StringBuilder();
        for (Map.Entry<String, ProfileSet> entry : this.store.entrySet()) {
            String profileMemberName = entry.getKey();
            ProfileSet profileSet = entry.getValue();
            storeDescription.append(profileMemberName).append(": ").append(profileSet).append("\r\n");
        }
        return storeDescription.toString();
    }

    static class UnitTest {
        UnitTest() {
        }

        public static void addProfileSet(ProfileStore store, ProfileSet profileSet) {
            store.addProfileSet(profileSet);
        }
    }
}

