/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config.loader.xml.extension;

import java.util.Optional;
import javax.inject.Inject;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.api.resource.visitor.dom.DOMElementVisitor;
import org.smooks.engine.resource.config.loader.xml.extension.ExtensionContext;
import org.smooks.engine.resource.config.loader.xml.extension.ResourceConfigUtils;
import org.w3c.dom.Element;

public class CloneResourceConfig
implements DOMElementVisitor {
    @Inject
    private Optional<String> resource;
    @Inject
    private Optional<String[]> unset;

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        ExtensionContext extensionContext = executionContext.get(ExtensionContext.EXTENSION_CONTEXT_TYPED_KEY);
        ResourceConfig config = extensionContext.getResourceStack().peek().copy();
        if (this.unset.isPresent()) {
            for (String property : this.unset.get()) {
                ResourceConfigUtils.unsetProperty(config, property);
            }
        }
        this.resource.ifPresent(config::setResource);
        extensionContext.addResourceConfig(config);
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        executionContext.get(ExtensionContext.EXTENSION_CONTEXT_TYPED_KEY).getResourceStack().pop();
    }
}

