/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config.loader.xml.extension;

import java.util.Properties;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.resource.config.Parameter;
import org.smooks.api.resource.config.ResourceConfig;
import org.smooks.engine.resource.config.loader.xml.extension.ExtensionContext;
import org.w3c.dom.Element;

public final class ResourceConfigUtils {
    private ResourceConfigUtils() {
    }

    public static void setProperty(ResourceConfig resourceConfig, String setOn, Object value, Element xml, ExecutionContext executionContext) throws SmooksException {
        if (setOn.equals("selector")) {
            resourceConfig.setSelector((String)value, new Properties());
        } else if (setOn.equals("resource")) {
            resourceConfig.setResource((String)value);
        } else if (setOn.equals("resourceType")) {
            resourceConfig.setResourceType((String)value);
        } else if (setOn.equals("defaultResource")) {
            resourceConfig.setSystem(Boolean.parseBoolean((String)value));
        } else if (setOn.equals("targetProfile")) {
            resourceConfig.setProfile((String)value);
        } else if (setOn.equals("conditionRef")) {
            ExtensionContext extensionContext = executionContext.get(ExtensionContext.EXTENSION_CONTEXT_TYPED_KEY);
            resourceConfig.getSelectorPath().setConditionEvaluator(extensionContext.getXmlResourceConfigLoader().getConditionEvaluator((String)value));
        } else {
            Parameter<Object> param = resourceConfig.setParameter(setOn, value);
            if (xml != null) {
                param.setXml(xml);
            }
        }
    }

    public static void setProperty(ResourceConfig resourceConfig, String setOn, Object value, ExecutionContext executionContext) throws SmooksException {
        ResourceConfigUtils.setProperty(resourceConfig, setOn, value, null, executionContext);
    }

    public static void unsetProperty(ResourceConfig resourceConfig, String property) {
        if (property.equals("selector")) {
            resourceConfig.setSelector(null, new Properties());
        } else if (property.equals("resource")) {
            resourceConfig.setResource(null);
        } else if (property.equals("resourceType")) {
            resourceConfig.setResourceType(null);
        } else if (property.equals("defaultResource")) {
            resourceConfig.setSystem(false);
        } else if (property.equals("targetProfile")) {
            resourceConfig.setProfile(null);
        } else if (property.equals("condition")) {
            resourceConfig.getSelectorPath().setConditionEvaluator(null);
        } else if (property.equals("conditionRef")) {
            resourceConfig.getSelectorPath().setConditionEvaluator(null);
        } else {
            resourceConfig.removeParameter(property);
        }
    }

    public static void mapProperty(ResourceConfig fromResourceConfig, String fromProperty, ResourceConfig toResourceConfig, String toProperty, String defaultValue, ExecutionContext executionContext) throws SmooksException {
        if (fromProperty.equals("selector")) {
            ResourceConfigUtils.setProperty(toResourceConfig, toProperty, fromResourceConfig.getSelectorPath().getSelector(), executionContext);
        } else if (fromProperty.equals("resource")) {
            ResourceConfigUtils.setProperty(toResourceConfig, toProperty, fromResourceConfig.getResource(), executionContext);
        } else if (fromProperty.equals("resourceType")) {
            ResourceConfigUtils.setProperty(toResourceConfig, toProperty, fromResourceConfig.getResourceType(), executionContext);
        } else if (fromProperty.equals("defaultResource")) {
            ResourceConfigUtils.setProperty(toResourceConfig, toProperty, fromResourceConfig.isSystem(), executionContext);
        } else if (fromProperty.equals("targetProfile")) {
            ResourceConfigUtils.setProperty(toResourceConfig, toProperty, fromResourceConfig.getProfile(), executionContext);
        } else if (fromProperty.equals("condition")) {
            toResourceConfig.getSelectorPath().setConditionEvaluator(fromResourceConfig.getSelectorPath().getConditionEvaluator());
        } else if (fromProperty.equals("conditionRef")) {
            toResourceConfig.getSelectorPath().setConditionEvaluator(fromResourceConfig.getSelectorPath().getConditionEvaluator());
        } else {
            ResourceConfigUtils.setProperty(toResourceConfig, toProperty, fromResourceConfig.getParameterValue(fromProperty, String.class, defaultValue), executionContext);
        }
    }
}

