/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config.xpath;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import org.smooks.api.SmooksException;
import org.smooks.api.expression.ExecutionContextExpressionEvaluator;
import org.smooks.api.expression.ExpressionEvaluator;
import org.smooks.api.resource.config.xpath.SelectorPath;
import org.smooks.api.resource.config.xpath.SelectorStep;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.resource.config.xpath.step.ElementSelectorStep;

public abstract class AbstractSelectorPath
implements SelectorPath {
    protected final Properties namespaces = new Properties();
    protected final List<SelectorStep> selectorSteps = new ArrayList<SelectorStep>();
    protected ExpressionEvaluator expressionEvaluator;
    protected String selector;

    @Override
    public Properties getNamespaces() {
        return this.namespaces;
    }

    @Override
    public void setNamespaces(Properties namespaces) {
        AssertArgument.isNotNull(namespaces, "namespaces");
        this.namespaces.putAll((Map<?, ?>)namespaces);
        for (int i = 0; i < this.selectorSteps.size(); ++i) {
            SelectorStep step = this.selectorSteps.get(i);
            try {
                step.getNamespaces().putAll((Map<?, ?>)this.namespaces);
            }
            catch (Exception e) {
                throw new SmooksException("Error compiling PredicatesEvaluator.", e);
            }
            if (i >= this.selectorSteps.size() - 1 || !(step instanceof ElementSelectorStep) || !((ElementSelectorStep)step).accessesText()) continue;
            throw new SmooksException("Unsupported XPath selector expression '" + this.selector + "'.  XPath 'text()' tokens are only supported in the last step.");
        }
    }

    @Override
    public String getSelector() {
        return this.selector;
    }

    @Override
    public int size() {
        return this.selectorSteps.size();
    }

    @Override
    public boolean isEmpty() {
        return this.selectorSteps.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.selectorSteps.contains(o);
    }

    @Override
    public Iterator<SelectorStep> iterator() {
        return this.selectorSteps.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.selectorSteps.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.selectorSteps.toArray(a);
    }

    @Override
    public boolean add(SelectorStep selectorStep) {
        return this.selectorSteps.add(selectorStep);
    }

    @Override
    public boolean remove(Object o) {
        return this.selectorSteps.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.selectorSteps.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends SelectorStep> c) {
        return this.selectorSteps.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends SelectorStep> c) {
        return this.selectorSteps.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.selectorSteps.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.selectorSteps.retainAll(c);
    }

    @Override
    public void clear() {
        this.selectorSteps.clear();
    }

    @Override
    public SelectorStep get(int index) {
        return this.selectorSteps.get(index);
    }

    @Override
    public SelectorStep set(int index, SelectorStep element) {
        return this.selectorSteps.set(index, element);
    }

    @Override
    public void add(int index, SelectorStep element) {
        this.selectorSteps.add(index, element);
    }

    @Override
    public SelectorStep remove(int index) {
        return this.selectorSteps.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.selectorSteps.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.selectorSteps.lastIndexOf(o);
    }

    @Override
    public ListIterator<SelectorStep> listIterator() {
        return this.selectorSteps.listIterator();
    }

    @Override
    public ListIterator<SelectorStep> listIterator(int index) {
        return this.selectorSteps.listIterator(index);
    }

    @Override
    public List<SelectorStep> subList(int fromIndex, int toIndex) {
        return this.selectorSteps.subList(fromIndex, toIndex);
    }

    public String toString() {
        return this.selector;
    }

    @Override
    public void setConditionEvaluator(ExpressionEvaluator expressionEvaluator) {
        if (expressionEvaluator != null && !(expressionEvaluator instanceof ExecutionContextExpressionEvaluator)) {
            throw new SmooksException("Unsupported ExpressionEvaluator type '" + expressionEvaluator.getClass().getName() + "'.  Currently only support '" + ExecutionContextExpressionEvaluator.class.getName() + "' implementations.");
        }
        this.expressionEvaluator = expressionEvaluator;
    }

    @Override
    public ExpressionEvaluator getConditionEvaluator() {
        return this.expressionEvaluator;
    }
}

