/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.engine.resource.config.xpath;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.saxpath.XPathReader;
import org.jaxen.saxpath.helpers.XPathReaderFactory;
import org.smooks.api.SmooksConfigException;
import org.smooks.api.SmooksException;
import org.smooks.api.expression.ExpressionEvaluator;
import org.smooks.api.resource.config.xpath.SelectorPath;
import org.smooks.api.resource.config.xpath.SelectorStep;
import org.smooks.assertion.AssertArgument;
import org.smooks.engine.resource.config.xpath.SelectorPathJaxenHandler;

public final class SelectorPathFactory {
    private SelectorPathFactory() {
    }

    public static SelectorPath newSelectorPath(String selector) {
        return SelectorPathFactory.newSelectorPath(selector, new Properties());
    }

    public static SelectorPath newSelectorPath(SelectorPath selectorPath) {
        return SelectorPathFactory.newSelectorPath(selectorPath.getSelector(), selectorPath.getNamespaces(), selectorPath.getConditionEvaluator());
    }

    public static SelectorPath newSelectorPath(String selector, Properties namespaces, ExpressionEvaluator conditionEvaluator) {
        SelectorPath newSelectorPath = SelectorPathFactory.newSelectorPath(selector, namespaces);
        newSelectorPath.setConditionEvaluator(conditionEvaluator);
        return newSelectorPath;
    }

    public static SelectorPath newSelectorPath(String selector, Properties namespaces) {
        AssertArgument.isNotEmpty(selector, "selector");
        int docSelectorIndex = selector.trim().indexOf("#document");
        if (docSelectorIndex > 0) {
            throw new SmooksConfigException("Invalid selector '" + selector + "'.  '" + "#document" + "' token can only exist at the start of the selector.");
        }
        SelectorPath selectorPath = SelectorPathFactory.buildSelectorPath(selector, namespaces);
        if (namespaces != null) {
            selectorPath.setNamespaces(namespaces);
        }
        return selectorPath;
    }

    private static SelectorPath buildSelectorPath(String selector, Properties namespaces) {
        XPathReader reader;
        AssertArgument.isNotNull(selector, "selector");
        String xpathExpression = selector.replaceAll("#document", "/*");
        try {
            reader = XPathReaderFactory.createReader();
        }
        catch (SAXPathException e) {
            throw new SmooksException(e);
        }
        try {
            reader.parse(xpathExpression);
        }
        catch (SAXPathException e) {
            if (selector.split(",").length > 1) {
                return new CompositeSelectorPath(selector, namespaces);
            }
            throw new SmooksException(e);
        }
        SelectorPathJaxenHandler xpathHandler = new SelectorPathJaxenHandler(xpathExpression, namespaces);
        if (!xpathExpression.trim().isEmpty()) {
            reader.setXPathHandler(xpathHandler);
            try {
                reader.parse(xpathExpression);
            }
            catch (SAXPathException e) {
                throw new SmooksException(e);
            }
        }
        return xpathHandler.getSelectorPath();
    }

    private static class CompositeSelectorPath
    implements SelectorPath {
        private final String selector;
        private Properties namespaces;

        public CompositeSelectorPath(String selector, Properties namespaces) {
            this.selector = selector;
            this.namespaces = namespaces;
        }

        @Override
        public String getSelector() {
            return this.selector;
        }

        @Override
        public void setConditionEvaluator(ExpressionEvaluator expressionEvaluator) {
        }

        @Override
        public ExpressionEvaluator getConditionEvaluator() {
            return null;
        }

        @Override
        public Properties getNamespaces() {
            return this.namespaces;
        }

        @Override
        public void setNamespaces(Properties namespaces) {
            this.namespaces = namespaces;
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<SelectorStep> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(SelectorStep selectorStep) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends SelectorStep> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(int index, Collection<? extends SelectorStep> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SelectorStep get(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SelectorStep set(int index, SelectorStep element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, SelectorStep element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SelectorStep remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int lastIndexOf(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<SelectorStep> listIterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<SelectorStep> listIterator(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SelectorStep> subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException();
        }
    }
}

