/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.io;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smooks.api.ExecutionContext;
import org.smooks.api.SmooksException;
import org.smooks.api.TypedKey;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.api.delivery.ordering.Consumer;
import org.smooks.api.lifecycle.PostExecutionLifecycle;
import org.smooks.api.lifecycle.PostFragmentLifecycle;
import org.smooks.api.resource.visitor.dom.DOMVisitBefore;
import org.smooks.api.resource.visitor.sax.ng.BeforeVisitor;
import org.smooks.assertion.AssertArgument;
import org.w3c.dom.Element;

public abstract class AbstractOutputStreamResource
implements DOMVisitBefore,
Consumer,
PostFragmentLifecycle,
PostExecutionLifecycle,
BeforeVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOutputStreamResource.class);
    static final String RESOURCE_CONTEXT_KEY_PREFIX = AbstractOutputStreamResource.class.getName() + "#outputresource:";
    static final String OUTPUTSTREAM_CONTEXT_KEY_PREFIX = AbstractOutputStreamResource.class.getName() + "#outputstream:";
    @Inject
    private String resourceName;
    @Inject
    private Charset writerEncoding = StandardCharsets.UTF_8;

    public abstract OutputStream getOutputStream(ExecutionContext var1) throws IOException;

    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public boolean consumes(Object object) {
        return object.equals(this.resourceName);
    }

    public AbstractOutputStreamResource setResourceName(String resourceName) {
        AssertArgument.isNotNullAndNotEmpty(resourceName, "resourceName");
        this.resourceName = resourceName;
        return this;
    }

    public AbstractOutputStreamResource setWriterEncoding(Charset writerEncoding) {
        AssertArgument.isNotNull(writerEncoding, "writerEncoding");
        this.writerEncoding = writerEncoding;
        return this;
    }

    public Charset getWriterEncoding() {
        return this.writerEncoding;
    }

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.bind(executionContext);
    }

    @Override
    public void onPostFragment(Fragment<?> fragment, ExecutionContext executionContext) {
        if (this.closeCondition(executionContext)) {
            this.closeResource(executionContext);
        }
    }

    @Override
    public void onPostExecution(ExecutionContext executionContext) {
        this.closeResource(executionContext);
    }

    protected boolean closeCondition(ExecutionContext executionContext) {
        return true;
    }

    protected void closeResource(ExecutionContext executionContext) {
        try {
            Closeable output = (Closeable)executionContext.get(TypedKey.of(OUTPUTSTREAM_CONTEXT_KEY_PREFIX + this.getResourceName()));
            this.close(output);
        }
        finally {
            executionContext.remove(TypedKey.of(OUTPUTSTREAM_CONTEXT_KEY_PREFIX + this.getResourceName()));
            executionContext.remove(TypedKey.of(RESOURCE_CONTEXT_KEY_PREFIX + this.getResourceName()));
        }
    }

    private void bind(ExecutionContext executionContext) {
        executionContext.put(TypedKey.of(RESOURCE_CONTEXT_KEY_PREFIX + this.getResourceName()), this);
    }

    private void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        if (closeable instanceof Flushable) {
            try {
                ((Flushable)((Object)closeable)).flush();
            }
            catch (IOException e) {
                LOGGER.warn("IOException while trying to flush output resource '" + this.resourceName + "': ", (Throwable)e);
            }
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            LOGGER.warn("IOException while trying to close output resource '" + this.resourceName + "': ", (Throwable)e);
        }
    }
}

