/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.io;

import java.io.IOException;
import java.io.Writer;
import org.smooks.api.ExecutionContext;
import org.smooks.api.delivery.fragment.Fragment;
import org.smooks.io.Stream;

public class FragmentWriter
extends Writer {
    public static final long RESERVED_WRITE_FRAGMENT_ID = 0L;
    private final Writer delegateWriter;
    private final Fragment<?> fragment;
    private final ExecutionContext executionContext;
    private final Boolean tryPark;

    public FragmentWriter(ExecutionContext executionContext, Fragment<?> fragment) {
        this(executionContext, fragment, true);
    }

    public FragmentWriter(ExecutionContext executionContext, Fragment<?> fragment, boolean tryPark) {
        this.executionContext = executionContext;
        this.delegateWriter = Stream.out(executionContext);
        this.fragment = fragment;
        this.tryPark = tryPark;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.park()) {
            this.delegateWriter.write(cbuf, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        this.delegateWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.delegateWriter.close();
    }

    public Writer getDelegateWriter() {
        return this.delegateWriter;
    }

    public boolean park() throws IOException {
        if (this.fragment.reserve(0L, this)) {
            return true;
        }
        if (this.tryPark.booleanValue()) {
            return false;
        }
        throw new IOException(String.format("Illegal access to fragment '%s': fragment is exclusively acquired by another writer. Hint: release fragment before acquiring it from a different writer", this.fragment.toString()));
    }

    public void unpark() throws IOException {
        this.fragment.release(0L, this);
    }

    public Fragment<?> getFragment() {
        return this.fragment;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }
}

