/*
 * Decompiled with CFR 0.152.
 */
package org.smooks.io.payload;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.xml.transform.Result;
import org.smooks.api.ApplicationContext;
import org.smooks.api.SmooksException;
import org.smooks.api.delivery.ContentHandler;
import org.smooks.assertion.AssertArgument;
import org.smooks.io.payload.Export;
import org.smooks.io.payload.ResultExtractor;
import org.smooks.support.ClassUtils;

public class Exports
implements ContentHandler {
    private final Map<Class<?>, Export> exportsMap = new HashMap();
    @Inject
    private ApplicationContext applicationContext;

    public Exports() {
    }

    public Exports(Export export) {
        this.addExport(export);
    }

    public Exports(Set<Export> exportTypes) {
        for (Export export : exportTypes) {
            this.addExport(export);
        }
    }

    public Exports(Class<?> resultType) {
        AssertArgument.isNotNull(resultType, "resultType");
        this.addExport(new Export(resultType));
    }

    public Exports(String resultType) {
        AssertArgument.isNotNull(resultType, "resultType");
        this.addExport(new Export(this.getClassForType(resultType)));
    }

    private Class<?> getClassForType(String type) {
        try {
            return ClassUtils.forName(type, Exports.class);
        }
        catch (ClassNotFoundException e) {
            throw new SmooksException("Could not load class for type [" + type + "].");
        }
    }

    public void addExport(Export export) {
        this.exportsMap.put(export.getType(), export);
    }

    public Collection<Export> getExports() {
        return Collections.unmodifiableCollection(this.exportsMap.values());
    }

    public Set<Class<?>> getResultTypes() {
        return Collections.unmodifiableSet(this.exportsMap.keySet());
    }

    public boolean hasExports() {
        return !this.exportsMap.isEmpty();
    }

    public Export getExport(Class<?> type) {
        return this.exportsMap.get(type);
    }

    public Result[] createResults() {
        HashSet<Result> results = new HashSet<Result>();
        for (Class<?> resultTypeClass : this.exportsMap.keySet()) {
            results.add(Exports.createResultInstance(resultTypeClass));
        }
        return results.toArray(new Result[0]);
    }

    public Collection<Export> getProducts() {
        return this.getExports();
    }

    public static List<Object> extractResults(Result[] results, Exports exports) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Result result : results) {
            if (result instanceof ResultExtractor) {
                ResultExtractor e = (ResultExtractor)((Object)result);
                objects.add(e.extractFromResult(result, exports.getExport(result.getClass())));
                continue;
            }
            objects.add(result);
        }
        return objects;
    }

    private static Result createResultInstance(Class<?> resultTypeClass) {
        try {
            return (Result)resultTypeClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new SmooksException("Could not instantiate instance for result type [" + resultTypeClass.getName() + "]", e);
        }
        catch (IllegalAccessException e) {
            throw new SmooksException("Could not create instance for result type [" + resultTypeClass.getName() + "]", e);
        }
    }
}

