/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Exchange;
import org.apache.camel.component.smpp.MessageReceiverListenerImpl;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppConnectionFactory;
import org.apache.camel.component.smpp.SmppEndpoint;
import org.apache.camel.component.smpp.SmppUtils;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.task.BlockingTask;
import org.apache.camel.util.ObjectHelper;
import org.jsmpp.DefaultPDUReader;
import org.jsmpp.DefaultPDUSender;
import org.jsmpp.SynchronizedPDUSender;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.util.DefaultComposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmppProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SmppProducer.class);
    private static final String RECONNECT_TASK_NAME = "smpp-producer-reconnect";
    private final SmppConfiguration configuration;
    private final SessionStateListener internalSessionStateListener;
    private final ReentrantLock connectLock = new ReentrantLock();
    private final ScheduledExecutorService reconnectService;
    private SMPPSession session;

    public SmppProducer(SmppEndpoint endpoint, SmppConfiguration config) {
        super(endpoint);
        this.reconnectService = SmppUtils.createExecutor(this, endpoint, RECONNECT_TASK_NAME);
        this.configuration = config;
        this.internalSessionStateListener = (newState, oldState, source) -> {
            if (this.configuration.getSessionStateListener() != null) {
                this.configuration.getSessionStateListener().onStateChange(newState, oldState, source);
            }
            if (newState.equals((Object)SessionState.UNBOUND) || newState.equals((Object)SessionState.CLOSED)) {
                LOG.warn(newState.equals((Object)SessionState.UNBOUND) ? "Session to {} was unbound - trying to reconnect" : "Lost connection to: {} - trying to reconnect...", (Object)this.getEndpoint().getConnectionString());
                this.closeSession();
                this.reconnect();
            }
        };
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (!this.getConfiguration().isLazySessionCreation()) {
            if (this.connectLock.tryLock()) {
                try {
                    this.session = this.createSession();
                }
                finally {
                    this.connectLock.unlock();
                }
            } else {
                LOG.warn("Thread {} could not acquire a lock for creating the session during producer start", (Object)Thread.currentThread().getId());
            }
        }
    }

    private SMPPSession createSession() throws Exception {
        LOG.debug("Connecting to: {}...", (Object)this.getEndpoint().getConnectionString());
        SMPPSession session = this.createSMPPSession();
        session.setEnquireLinkTimer(this.configuration.getEnquireLinkTimer());
        session.setTransactionTimer(this.configuration.getTransactionTimer().intValue());
        session.setPduProcessorDegree(this.configuration.getPduProcessorDegree());
        session.setQueueCapacity(this.configuration.getPduProcessorQueueCapacity());
        session.addSessionStateListener(this.internalSessionStateListener);
        BindType bindType = BindType.BIND_TX;
        if (ObjectHelper.isNotEmpty(this.configuration.getMessageReceiverRouteId())) {
            session.setMessageReceiverListener(new MessageReceiverListenerImpl(this.getEndpoint(), this.configuration.getMessageReceiverRouteId()));
            bindType = BindType.BIND_TRX;
        }
        session.connectAndBind(this.configuration.getHost(), this.configuration.getPort(), new BindParameter(bindType, this.configuration.getSystemId(), this.configuration.getPassword(), this.configuration.getSystemType(), TypeOfNumber.valueOf(this.configuration.getTypeOfNumber()), NumberingPlanIndicator.valueOf(this.configuration.getNumberingPlanIndicator()), "", this.configuration.getInterfaceVersionByte()));
        LOG.info("Connected to: {}", (Object)this.getEndpoint().getConnectionString());
        return session;
    }

    SMPPSession createSMPPSession() {
        return new SMPPSession(new SynchronizedPDUSender(new DefaultPDUSender(new DefaultComposer())), new DefaultPDUReader(), SmppConnectionFactory.getInstance(this.configuration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void process(Exchange exchange) throws Exception {
        if (this.session == null && this.configuration.isLazySessionCreation()) {
            if (this.connectLock.tryLock()) {
                try {
                    if (this.session != null) ** GOTO lbl18
                    in = exchange.getIn();
                    systemId = in.getHeader("CamelSmppSystemId", String.class);
                    password = in.getHeader("CamelSmppPassword", String.class);
                    if (systemId != null && password != null) {
                        SmppProducer.LOG.info("using the system id '{}' to connect to the SMSC...", (Object)systemId);
                        this.configuration.setSystemId(systemId);
                        this.configuration.setPassword(password);
                    }
                    this.session = this.createSession();
                }
                finally {
                    this.connectLock.unlock();
                }
            } else {
                SmppProducer.LOG.warn("Thread {} could not acquire a lock for creating the session during lazy initialization", (Object)Thread.currentThread().getId());
            }
        }
lbl18:
        // 5 sources

        if (this.session == null) {
            throw new IOException("Lost connection to " + this.getEndpoint().getConnectionString() + " and yet not reconnected");
        }
        command = this.getEndpoint().getBinding().createSmppCommand(this.session, exchange);
        command.execute(exchange);
    }

    @Override
    protected void doStop() throws Exception {
        SmppUtils.shutdownReconnectService(this.reconnectService);
        LOG.debug("Disconnecting from: {}...", (Object)this.getEndpoint().getConnectionString());
        super.doStop();
        this.closeSession();
        LOG.info("Disconnected from: {}", (Object)this.getEndpoint().getConnectionString());
    }

    private void closeSession() {
        if (this.session != null) {
            this.session.removeSessionStateListener(this.internalSessionStateListener);
            this.session.unbindAndClose();
            this.session = null;
        }
    }

    private void reconnect() {
        if (this.connectLock.tryLock()) {
            BlockingTask task = SmppUtils.newReconnectTask(this.reconnectService, RECONNECT_TASK_NAME, this.configuration.getInitialReconnectDelay(), this.configuration.getReconnectDelay(), this.configuration.getMaxReconnect());
            try {
                task.run(this::doReconnect);
            }
            finally {
                this.connectLock.unlock();
            }
        } else {
            LOG.warn("Thread {} could not acquire a lock for creating the session during producer reconnection", (Object)Thread.currentThread().getId());
        }
    }

    private boolean doReconnect() {
        try {
            LOG.info("Trying to reconnect to {}", (Object)this.getEndpoint().getConnectionString());
            if (SmppUtils.isServiceStopping(this)) {
                return true;
            }
            if (SmppUtils.isSessionClosed(this.session)) {
                return this.tryCreateSession();
            }
            LOG.info("Nothing to do: the session is not closed");
        }
        catch (Exception e) {
            LOG.error("Unable to reconnect to {}: {}", new Object[]{this.getEndpoint().getConnectionString(), e.getMessage(), e});
            return false;
        }
        return true;
    }

    private boolean tryCreateSession() {
        try {
            this.session = this.createSession();
            return true;
        }
        catch (Exception e) {
            LOG.warn("Failed to reconnect to {}", (Object)this.getEndpoint().getConnectionString());
            this.closeSession();
            return false;
        }
    }

    @Override
    public SmppEndpoint getEndpoint() {
        return (SmppEndpoint)super.getEndpoint();
    }

    public SmppConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public String toString() {
        return "SmppProducer[" + this.getEndpoint().getConnectionString() + "]";
    }
}

