/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import java.util.Objects;
import org.jsmpp.bean.DestinationAddress;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.TypeOfNumber;

public class Address
implements DestinationAddress {
    private TypeOfNumber typeOfNumber;
    private NumberingPlanIndicator numberingPlanIndicator;
    private String address;

    public Address(TypeOfNumber typeOfNumber, NumberingPlanIndicator numberingPlanIndicator, String address) {
        this.typeOfNumber = typeOfNumber;
        this.numberingPlanIndicator = numberingPlanIndicator;
        this.address = address;
    }

    public Address(byte typeOfNumber, byte numberingPlanIndicator, String address) {
        this(TypeOfNumber.valueOf(typeOfNumber), NumberingPlanIndicator.valueOf(numberingPlanIndicator), address);
    }

    @Override
    public DestinationAddress.Flag getFlag() {
        return DestinationAddress.Flag.SME_ADDRESS;
    }

    public TypeOfNumber getTypeOfNumber() {
        return this.typeOfNumber;
    }

    public byte getTon() {
        return this.typeOfNumber.value();
    }

    public NumberingPlanIndicator getNumberingPlanIndicator() {
        return this.numberingPlanIndicator;
    }

    public byte getNpi() {
        return this.numberingPlanIndicator.value();
    }

    public String getAddress() {
        return this.address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address1 = (Address)o;
        return this.typeOfNumber == address1.typeOfNumber && this.numberingPlanIndicator == address1.numberingPlanIndicator && Objects.equals(this.address, address1.address);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.typeOfNumber, this.numberingPlanIndicator, this.address});
    }
}

