/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean.pid;

import org.jsmpp.util.HexUtil;

public enum TelematicDevice {
    IMPLICIT(0),
    TELEX(1),
    GRP_3_TELEFAX(2),
    GRP_4_TELEFAX(3),
    VOICE_TELEPHONE(4),
    ERMES(5),
    NATIONAL_PAGING_SYSTEM(6),
    VIDEOTEX(7),
    TELETEXCARRIER_UNSPECIFIED(8),
    TELETEX_IN_PSPDND(9),
    TELETEX_IN_CSPDN(10),
    TELETEX_ANALOG_PSTN(11),
    TELETEX_DIGITAL_ISDN(12),
    UCI(13),
    RESERVED_1(14),
    RESERVED_2(15),
    MESSAGE_HANDLING_FACILITY(16),
    X_400_BASED(17),
    INTERNET_ELECTRONIC_MAIL(18),
    RESERVED_3(19),
    RESERVED_4(20),
    RESERVED_5(21),
    RESERVED_6(22),
    RESERVED_7(23),
    SPECIFIC_EACH_SC_1(24),
    SPECIFIC_EACH_SC_2(25),
    SPECIFIC_EACH_SC_3(26),
    SPECIFIC_EACH_SC_4(27),
    SPECIFIC_EACH_SC_5(28),
    SPECIFIC_EACH_SC_6(29),
    SPECIFIC_EACH_SC_7(30),
    GSM_UMTS(31);

    private byte encoding;

    private TelematicDevice(byte encoding) {
        this.encoding = encoding;
    }

    public static TelematicDevice valueOf(byte encoding) {
        for (TelematicDevice telematicDevice : TelematicDevice.values()) {
            if (telematicDevice.encoding != (encoding & 0x1F)) continue;
            return telematicDevice;
        }
        throw new IllegalArgumentException("Could not recognize telematic device from encoding '" + HexUtil.convertByteToHexString(encoding) + "'.");
    }

    public byte value() {
        return this.encoding;
    }
}

