/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.PDUSender;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DataSmResp;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.EnquireLink;
import org.jsmpp.bean.InterfaceVersion;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.PendingResponse;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.AbstractSessionContext;
import org.jsmpp.session.DataSmCommandTask;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.EnquireLinkCommandTask;
import org.jsmpp.session.GenericMessageReceiverListener;
import org.jsmpp.session.OutbindCommandTask;
import org.jsmpp.session.SendCommandTask;
import org.jsmpp.session.Session;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.UnbindCommandTask;
import org.jsmpp.session.connection.Connection;
import org.jsmpp.util.IntUtil;
import org.jsmpp.util.Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSession
implements Session,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(AbstractSession.class);
    private static final Random random = new Random();
    private final Map<Integer, PendingResponse<Command>> pendingResponses = new ConcurrentHashMap<Integer, PendingResponse<Command>>();
    private final Sequence sequence = new Sequence(1);
    private final PDUSender pduSender;
    private int pduProcessorDegree = 3;
    private int queueCapacity = 100;
    private final String sessionId = AbstractSession.generateSessionId();
    private int enquireLinkTimer = 60000;
    private long transactionTimer = 2000L;
    protected EnquireLinkSender enquireLinkSender;

    protected AbstractSession(PDUSender pduSender) {
        this.pduSender = pduSender;
    }

    protected abstract AbstractSessionContext sessionContext();

    protected abstract Connection connection();

    protected abstract GenericMessageReceiverListener messageReceiverListener();

    protected PDUSender pduSender() {
        return this.pduSender;
    }

    protected Sequence sequence() {
        return this.sequence;
    }

    protected PendingResponse<Command> removePendingResponse(int sequenceNumber) {
        return this.pendingResponses.remove(sequenceNumber);
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public void setInterfaceVersion(InterfaceVersion interfaceVersion) {
        this.sessionContext().setInterfaceVersion(interfaceVersion);
    }

    @Override
    public InterfaceVersion getInterfaceVersion() {
        return this.sessionContext().getInterfaceVersion();
    }

    @Override
    public void setEnquireLinkTimer(int enquireLinkTimer) {
        if (this.sessionContext().getSessionState().isNotClosed()) {
            try {
                this.connection().setSoTimeout(enquireLinkTimer);
            }
            catch (IOException e) {
                log.error("Setting so_timeout for session timer failed", (Throwable)e);
            }
        }
        this.enquireLinkTimer = enquireLinkTimer;
    }

    @Override
    public int getEnquireLinkTimer() {
        return this.enquireLinkTimer;
    }

    @Override
    public void setTransactionTimer(long transactionTimer) {
        this.transactionTimer = transactionTimer;
    }

    @Override
    public long getTransactionTimer() {
        return this.transactionTimer;
    }

    @Override
    public int getUnacknowledgedRequests() {
        return this.pendingResponses.size();
    }

    @Override
    public SessionState getSessionState() {
        return this.sessionContext().getSessionState();
    }

    protected synchronized boolean isReadPdu() {
        SessionState sessionState = this.getSessionState();
        return sessionState.isBound() || sessionState.equals((Object)SessionState.OPEN) || sessionState.equals((Object)SessionState.OUTBOUND);
    }

    @Override
    public void addSessionStateListener(SessionStateListener listener) {
        if (listener != null) {
            this.sessionContext().addSessionStateListener(listener);
        }
    }

    @Override
    public void removeSessionStateListener(SessionStateListener listener) {
        this.sessionContext().removeSessionStateListener(listener);
    }

    @Override
    public long getLastActivityTimestamp() {
        return this.sessionContext().getLastActivityTimestamp();
    }

    public void setPduProcessorDegree(int pduProcessorDegree) throws IllegalStateException {
        if (!this.getSessionState().equals((Object)SessionState.CLOSED)) {
            throw new IllegalStateException("Cannot set PDU processor degree since the PDU dispatcher thread is already created");
        }
        this.pduProcessorDegree = pduProcessorDegree;
    }

    public int getPduProcessorDegree() {
        return this.pduProcessorDegree;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    @Override
    public DataSmResult dataShortMessage(String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber destAddrTon, NumberingPlanIndicator destAddrNpi, String destinationAddr, ESMClass esmClass, RegisteredDelivery registeredDelivery, DataCoding dataCoding, OptionalParameter ... optionalParameters) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        DataSmCommandTask task = new DataSmCommandTask(this.pduSender, serviceType, sourceAddrTon, sourceAddrNpi, sourceAddr, destAddrTon, destAddrNpi, destinationAddr, esmClass, registeredDelivery, dataCoding, optionalParameters);
        DataSmResp resp = (DataSmResp)this.executeSendCommand(task, this.getTransactionTimer());
        return new DataSmResult(resp.getMessageId(), resp.getOptionalParameters());
    }

    @Override
    public void close() {
        AbstractSessionContext ctx = this.sessionContext();
        SessionState sessionState = ctx.getSessionState();
        if (!sessionState.equals((Object)SessionState.CLOSED)) {
            log.debug("Close session {} in state {}", (Object)this.sessionId, (Object)this.getSessionState());
            try {
                this.connection().close();
            }
            catch (IOException e) {
                log.warn("Close connection failed", (Throwable)e);
            }
        }
        if (Thread.currentThread() != this.enquireLinkSender) {
            if (this.enquireLinkSender != null && this.enquireLinkSender.isAlive()) {
                log.debug("Stop enquireLinkSender for session {}", (Object)this.sessionId);
                try {
                    this.enquireLinkSender.interrupt();
                    this.enquireLinkSender.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.warn("Interrupted while waiting for enquireLinkSender thread to exit");
                }
            }
            if (!sessionState.equals((Object)SessionState.CLOSED)) {
                log.debug("Close session context {} in state {}", (Object)this.sessionId, (Object)sessionState);
                ctx.close();
            }
        }
    }

    private static void validateResponse(Command response) throws NegativeResponseException {
        if (response.getCommandStatus() != 0) {
            throw new NegativeResponseException(response.getCommandStatus());
        }
    }

    protected DataSmResult fireAcceptDataSm(DataSm dataSm) throws ProcessRequestException {
        GenericMessageReceiverListener messageReceiverListener = this.messageReceiverListener();
        if (messageReceiverListener != null) {
            return messageReceiverListener.onAcceptDataSm(dataSm, this);
        }
        throw new ProcessRequestException("MessageReceiverListener hasn't been set yet", 102);
    }

    protected void fireAcceptEnquirelink(EnquireLink enquireLink) {
        GenericMessageReceiverListener messageReceiverListener = this.messageReceiverListener();
        if (messageReceiverListener != null) {
            messageReceiverListener.onAcceptEnquireLink(enquireLink, this);
        }
    }

    protected Command executeSendCommand(SendCommandTask task, long timeout) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        int seqNum = this.sequence.nextValue();
        PendingResponse pendingResp = new PendingResponse(timeout);
        this.pendingResponses.put(seqNum, pendingResp);
        try {
            task.executeTask(this.connection().getOutputStream(), seqNum);
        }
        catch (IOException e) {
            log.error("Sending {} command failed", (Object)task.getCommandName(), (Object)e);
            if ("enquire_link".equals(task.getCommandName())) {
                log.info("Ignore failure of sending enquire_link, wait to see if connection is restored");
            }
            this.pendingResponses.remove(seqNum);
            this.close();
            throw e;
        }
        try {
            pendingResp.waitDone();
            if ("enquire_link".equals(task.getCommandName())) {
                if (log.isTraceEnabled()) {
                    log.trace("{} response with sequence_number {} received for session {}", new Object[]{task.getCommandName(), seqNum, this.sessionId});
                }
            } else {
                log.debug("{} response with sequence_number {} received for session {}", new Object[]{task.getCommandName(), seqNum, this.sessionId});
            }
        }
        catch (ResponseTimeoutException e) {
            this.pendingResponses.remove(seqNum);
            throw new ResponseTimeoutException("No response after waiting for " + timeout + " millis when executing " + task.getCommandName() + " with session " + this.sessionId + " and sequence_number " + seqNum, e);
        }
        catch (InvalidResponseException e) {
            this.pendingResponses.remove(seqNum);
            throw e;
        }
        Object resp = pendingResp.getResponse();
        AbstractSession.validateResponse(resp);
        return resp;
    }

    protected void executeSendCommandWithNoResponse(SendCommandTask task) throws PDUException, IOException {
        int seqNum = this.sequence.nextValue();
        try {
            task.executeTask(this.connection().getOutputStream(), seqNum);
        }
        catch (IOException e) {
            log.error("Sending {} command failed: {}", (Object)task.getCommandName(), (Object)e.getMessage());
            this.close();
            throw e;
        }
    }

    private static synchronized String generateSessionId() {
        return IntUtil.toHexString(random.nextInt());
    }

    protected void sendEnquireLink() throws ResponseTimeoutException, InvalidResponseException, IOException {
        EnquireLinkCommandTask task = new EnquireLinkCommandTask(this.pduSender);
        try {
            this.executeSendCommand(task, this.getTransactionTimer());
        }
        catch (PDUException e) {
            log.warn("PDU String should be always valid", (Throwable)e);
        }
        catch (NegativeResponseException e) {
            log.warn("command_status of enquire_link_resp should be always 0", (Throwable)e);
        }
    }

    public void sendOutbind(String systemId, String password) throws IOException {
        if (this.sessionContext().getSessionState().equals((Object)SessionState.CLOSED)) {
            throw new IOException("Session " + this.sessionId + " is closed");
        }
        OutbindCommandTask task = new OutbindCommandTask(this.pduSender, systemId, password);
        try {
            this.executeSendCommandWithNoResponse(task);
        }
        catch (PDUException e) {
            log.warn("PDU String should be always valid", (Throwable)e);
        }
    }

    public void unbind() throws IOException {
        if (this.sessionContext().getSessionState().equals((Object)SessionState.CLOSED)) {
            throw new IOException("Session " + this.sessionId + " is closed");
        }
        UnbindCommandTask task = new UnbindCommandTask(this.pduSender);
        try {
            this.executeSendCommand(task, this.transactionTimer);
        }
        catch (PDUException e) {
            log.warn("PDU String should be always valid", (Throwable)e);
        }
        catch (ResponseTimeoutException e) {
            log.warn("Unbind response timeout", (Throwable)e);
        }
        catch (InvalidResponseException e) {
            log.warn("Invalid response for unbind", (Throwable)e);
        }
        catch (NegativeResponseException e) {
            log.warn("Receive non-ok command_status ({}) for unbind_resp", (Object)e.getCommandStatus());
        }
    }

    @Override
    public void unbindAndClose() {
        log.debug("Unbind and close session {}", (Object)this.sessionId);
        if (this.sessionContext().getSessionState().isBound()) {
            try {
                this.unbind();
            }
            catch (IOException e) {
                log.error("IO error found", (Throwable)e);
            }
        }
        this.close();
    }

    protected void ensureReceivable(String activityName) throws IOException {
        SessionState currentState = this.getSessionState();
        if (!currentState.isReceivable()) {
            throw new IOException("Cannot " + activityName + " while session " + this.sessionId + " in state " + (Object)((Object)currentState));
        }
    }

    protected void ensureTransmittable(String activityName) throws IOException {
        this.ensureTransmittable(activityName, false);
    }

    protected void ensureTransmittable(String activityName, boolean only) throws IOException {
        SessionState currentState = this.getSessionState();
        if (currentState.isNotClosed() && "enquire_link".equals(activityName)) {
            return;
        }
        if (!currentState.isTransmittable() || only && currentState.isReceivable()) {
            throw new IOException("Cannot " + activityName + " while session " + this.sessionId + " in state " + (Object)((Object)currentState));
        }
    }

    protected class EnquireLinkSender
    extends Thread {
        private final AtomicBoolean sendingEnquireLink;

        public EnquireLinkSender() {
            super("EnquireLinkSender-" + AbstractSession.this.sessionId);
            this.sendingEnquireLink = new AtomicBoolean(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (AbstractSession.this.enquireLinkTimer == 0) {
                return;
            }
            log.debug("Starting EnquireLinkSender for session {}", (Object)AbstractSession.this.sessionId);
            while (AbstractSession.this.getSessionState().isNotClosed()) {
                while (!this.sendingEnquireLink.compareAndSet(true, false) && !Thread.currentThread().isInterrupted() && AbstractSession.this.getSessionState() != SessionState.CLOSED) {
                    AtomicBoolean atomicBoolean = this.sendingEnquireLink;
                    synchronized (atomicBoolean) {
                        try {
                            this.sendingEnquireLink.wait(500L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    }
                }
                if (Thread.currentThread().isInterrupted() || AbstractSession.this.getSessionState() == SessionState.CLOSED) break;
                try {
                    AbstractSession.this.sendEnquireLink();
                }
                catch (ResponseTimeoutException e) {
                    log.error("Response timeout on enquire_link", (Throwable)e);
                    AbstractSession.this.close();
                }
                catch (InvalidResponseException e) {
                    log.error("Invalid response on enquire_link", (Throwable)e);
                    AbstractSession.this.unbindAndClose();
                }
                catch (IOException e) {
                    log.error("I/O exception on enquire_link", (Throwable)e);
                    AbstractSession.this.close();
                }
            }
            log.debug("EnquireLinkSender stopped for session {}", (Object)AbstractSession.this.sessionId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enquireLink() {
            if (this.sendingEnquireLink.compareAndSet(false, true)) {
                AtomicBoolean atomicBoolean = this.sendingEnquireLink;
                synchronized (atomicBoolean) {
                    this.sendingEnquireLink.notify();
                }
            } else {
                log.debug("Not sending enquire link notify");
            }
        }
    }
}

