/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jsmpp.DefaultPDUReader;
import org.jsmpp.DefaultPDUSender;
import org.jsmpp.InvalidCommandLengthException;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.PDUReader;
import org.jsmpp.PDUSender;
import org.jsmpp.PDUStringException;
import org.jsmpp.SynchronizedPDUSender;
import org.jsmpp.bean.Bind;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.EnquireLink;
import org.jsmpp.bean.InterfaceVersion;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.PendingResponse;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.QueueMaxException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.AbstractSession;
import org.jsmpp.session.AbstractSessionContext;
import org.jsmpp.session.BindRequest;
import org.jsmpp.session.BindRequestReceiver;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.DeliverSmCommandTask;
import org.jsmpp.session.GenericMessageReceiverListener;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.OutbindParameter;
import org.jsmpp.session.OutboundClientSession;
import org.jsmpp.session.OutboundResponseHandler;
import org.jsmpp.session.PDUProcessOutboundTask;
import org.jsmpp.session.PDUProcessTask;
import org.jsmpp.session.SMPPOutboundSessionContext;
import org.jsmpp.session.Session;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.connection.Connection;
import org.jsmpp.session.connection.ConnectionFactory;
import org.jsmpp.session.connection.socket.SocketConnectionFactory;
import org.jsmpp.util.DefaultComposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPPOutboundSession
extends AbstractSession
implements OutboundClientSession {
    private static final Logger log = LoggerFactory.getLogger(SMPPOutboundSession.class);
    private final PDUReader pduReader;
    private final ConnectionFactory connFactory;
    private final OutboundResponseHandler responseHandler = new ResponseHandlerImpl();
    private Connection conn;
    private DataInputStream in;
    private OutputStream out;
    private PDUReaderWorker pduReaderWorker;
    private MessageReceiverListener messageReceiverListener;
    private BoundSessionStateListener sessionStateListener = new BoundSessionStateListener();
    private SMPPOutboundSessionContext sessionContext = new SMPPOutboundSessionContext(this, this.sessionStateListener);
    private BindRequestReceiver bindRequestReceiver = new BindRequestReceiver(this.responseHandler);

    public SMPPOutboundSession() {
        this(new SynchronizedPDUSender(new DefaultPDUSender(new DefaultComposer())), new DefaultPDUReader(), SocketConnectionFactory.getInstance());
    }

    public SMPPOutboundSession(PDUSender pduSender, PDUReader pduReader, ConnectionFactory connFactory) {
        super(pduSender);
        this.pduReader = pduReader;
        this.connFactory = connFactory;
    }

    public SMPPOutboundSession(String host, int port, OutbindParameter outbindParam, PDUSender pduSender, PDUReader pduReader, ConnectionFactory connFactory) throws IOException {
        this(pduSender, pduReader, connFactory);
        this.connectAndOutbind(host, port, outbindParam);
    }

    @Override
    public BindRequest connectAndOutbind(String host, int port, OutbindParameter outbindParam) throws IOException {
        return this.connectAndOutbind(host, port, outbindParam, 60000L);
    }

    @Override
    public BindRequest connectAndOutbind(String host, int port, String systemId, String password) throws IOException {
        return this.connectAndOutbind(host, port, new OutbindParameter(systemId, password), 60000L);
    }

    @Override
    public BindRequest connectAndOutbind(String host, int port, String systemId, String password, long timeout) throws IOException {
        return this.connectAndOutbind(host, port, new OutbindParameter(systemId, password), timeout);
    }

    @Override
    public BindRequest connectAndOutbind(String host, int port, OutbindParameter outbindParameter, long timeout) throws IOException {
        log.debug("Connect and bind to {} port {}", (Object)host, (Object)port);
        if (this.getSessionState() != SessionState.CLOSED) {
            throw new IOException("Session state is not closed");
        }
        this.conn = this.connFactory.createConnection(host, port);
        log.info("Connected to {}", (Object)this.conn.getInetAddress());
        this.conn.setSoTimeout(this.getEnquireLinkTimer());
        this.sessionContext.open();
        try {
            this.in = new DataInputStream(this.conn.getInputStream());
            this.out = this.conn.getOutputStream();
            this.pduReaderWorker = new PDUReaderWorker(this.getPduProcessorDegree(), this.getQueueCapacity());
            this.pduReaderWorker.start();
            this.sendOutbind(outbindParameter.getSystemId(), outbindParameter.getPassword());
        }
        catch (IOException e) {
            log.error("I/O error occurred", (Throwable)e);
            this.close();
            throw e;
        }
        try {
            BindRequest bindRequest = this.waitForBind(timeout);
            this.enquireLinkSender = new AbstractSession.EnquireLinkSender();
            this.enquireLinkSender.start();
            return bindRequest;
        }
        catch (IllegalStateException e) {
            String message = "System error";
            log.error(message, (Throwable)e);
            this.close();
            throw new IOException(message + ": " + e.getMessage(), e);
        }
        catch (TimeoutException e) {
            String message = "Wait for bind response timed out";
            log.error(message, (Throwable)e);
            throw new IOException(message + ": " + e.getMessage(), e);
        }
    }

    private BindRequest waitForBind(long timeout) throws IllegalStateException, TimeoutException {
        SessionState currentSessionState = this.getSessionState();
        if (currentSessionState.equals((Object)SessionState.OPEN)) {
            try {
                return this.bindRequestReceiver.waitForRequest(timeout);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Invocation of waitForBind() has been made", e);
            }
            catch (TimeoutException e) {
                this.close();
                throw e;
            }
        }
        throw new IllegalStateException("waitForBind() should be invoked on OPEN state, actual state is " + (Object)((Object)currentSessionState));
    }

    @Override
    public void deliverShortMessage(String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber destAddrTon, NumberingPlanIndicator destAddrNpi, String destinationAddr, ESMClass esmClass, byte protocolId, byte priorityFlag, RegisteredDelivery registeredDelivery, DataCoding dataCoding, byte[] shortMessage, OptionalParameter ... optionalParameters) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        this.ensureReceivable("deliver_sm");
        DeliverSmCommandTask task = new DeliverSmCommandTask(this.pduSender(), serviceType, sourceAddrTon, sourceAddrNpi, sourceAddr, destAddrTon, destAddrNpi, destinationAddr, esmClass, protocolId, priorityFlag, registeredDelivery, dataCoding, shortMessage, optionalParameters);
        this.executeSendCommand(task, this.getTransactionTimer());
    }

    @Override
    public MessageReceiverListener getMessageReceiverListener() {
        return this.messageReceiverListener;
    }

    @Override
    public void setMessageReceiverListener(MessageReceiverListener messageReceiverListener) {
        this.messageReceiverListener = messageReceiverListener;
    }

    @Override
    protected Connection connection() {
        return this.conn;
    }

    @Override
    protected AbstractSessionContext sessionContext() {
        return this.sessionContext;
    }

    @Override
    protected GenericMessageReceiverListener messageReceiverListener() {
        return this.messageReceiverListener;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private class BoundSessionStateListener
    implements SessionStateListener {
        private BoundSessionStateListener() {
        }

        @Override
        public void onStateChange(SessionState newState, SessionState oldState, Session source) {
            if (newState.isBound()) {
                try {
                    SMPPOutboundSession.this.conn.setSoTimeout(SMPPOutboundSession.this.getEnquireLinkTimer());
                }
                catch (IOException e) {
                    log.error("Failed setting so_timeout for enquire link timer", (Throwable)e);
                }
                int pduProcessorDegree = SMPPOutboundSession.this.getPduProcessorDegree();
                log.debug("Changing processor degree to {}", (Object)pduProcessorDegree);
                SMPPOutboundSession.this.pduReaderWorker.pduExecutor.setMaximumPoolSize(pduProcessorDegree);
                SMPPOutboundSession.this.pduReaderWorker.pduExecutor.setCorePoolSize(pduProcessorDegree);
            }
        }
    }

    private class PDUReaderWorker
    extends Thread {
        private ThreadPoolExecutor pduExecutor;
        private LinkedBlockingQueue<Runnable> workQueue;
        private int queueCapacity;
        private Runnable onIOExceptionTask;

        private PDUReaderWorker(int pduProcessorDegree, int queueCapacity) {
            super("PDUReaderWorker-" + SMPPOutboundSession.this.getSessionId());
            this.onIOExceptionTask = () -> SMPPOutboundSession.this.close();
            this.queueCapacity = queueCapacity;
            this.workQueue = new LinkedBlockingQueue(queueCapacity);
            this.pduExecutor = new ThreadPoolExecutor(pduProcessorDegree, pduProcessorDegree, 0L, TimeUnit.MILLISECONDS, this.workQueue, (runnable, executor) -> {
                log.info("Receiving queue is full, please increasing receive queue capacity, and/or let other side obey the window size");
                Command pduHeader = ((PDUProcessTask)runnable).getPduHeader();
                if ((pduHeader.getCommandId() & Integer.MIN_VALUE) != Integer.MIN_VALUE) throw new QueueMaxException("Receiving queue capacity " + queueCapacity + " exceeded");
                try {
                    boolean success = executor.getQueue().offer(runnable, 60000L, TimeUnit.MILLISECONDS);
                    if (success) return;
                    log.warn("Offer to receive queue failed for {}", (Object)pduHeader);
                    return;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            });
        }

        @Override
        public void run() {
            while (SMPPOutboundSession.this.isReadPdu()) {
                this.readPDU();
            }
            SMPPOutboundSession.this.close();
            this.pduExecutor.shutdown();
            try {
                this.pduExecutor.awaitTermination(SMPPOutboundSession.this.getTransactionTimer(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for PDU executor pool to finish");
                Thread.currentThread().interrupt();
            }
            log.debug("{} stopped", (Object)this.getName());
        }

        private void readPDU() {
            Command pduHeader = null;
            try {
                pduHeader = SMPPOutboundSession.this.pduReader.readPDUHeader(SMPPOutboundSession.this.in);
                byte[] pdu = SMPPOutboundSession.this.pduReader.readPDU(SMPPOutboundSession.this.in, pduHeader);
                PDUProcessOutboundTask task = new PDUProcessOutboundTask(pduHeader, pdu, SMPPOutboundSession.this.sessionContext, SMPPOutboundSession.this.responseHandler, SMPPOutboundSession.this.sessionContext, this.onIOExceptionTask);
                this.pduExecutor.execute(task);
            }
            catch (QueueMaxException e) {
                log.info("Notify other side to throttle: {} ({} threads active)", (Object)e.getMessage(), (Object)this.pduExecutor.getActiveCount());
                try {
                    SMPPOutboundSession.this.responseHandler.sendNegativeResponse(pduHeader.getCommandId(), 88, pduHeader.getSequenceNumber());
                }
                catch (IOException ioe) {
                    log.warn("Failed sending negative response: {}", (Object)ioe.getMessage());
                    SMPPOutboundSession.this.close();
                }
            }
            catch (InvalidCommandLengthException e) {
                log.warn("Received invalid command length: {}", (Object)e.getMessage());
                try {
                    SMPPOutboundSession.this.pduSender().sendGenericNack(SMPPOutboundSession.this.out, 2, 0);
                }
                catch (IOException ee) {
                    log.warn("Failed sending generic nack", (Throwable)ee);
                }
                SMPPOutboundSession.this.unbindAndClose();
            }
            catch (SocketTimeoutException e) {
                this.notifyNoActivity();
            }
            catch (IOException e) {
                log.info("Reading PDU session {} in state {}: {}", new Object[]{SMPPOutboundSession.this.getSessionId(), SMPPOutboundSession.this.getSessionState(), e.getMessage()});
                SMPPOutboundSession.this.close();
            }
            catch (RuntimeException e) {
                log.warn("Runtime error while reading", (Throwable)e);
                SMPPOutboundSession.this.close();
            }
        }

        private void notifyNoActivity() {
            SessionState sessionState = SMPPOutboundSession.this.sessionContext().getSessionState();
            if (SMPPOutboundSession.this.getInterfaceVersion().compareTo(InterfaceVersion.IF_34) > 0 && sessionState.isNotClosed() || sessionState.isBound()) {
                log.trace("No activity notified, sending enquire_link");
                SMPPOutboundSession.this.enquireLinkSender.enquireLink();
            }
        }

        public int getCongestionRatio() {
            return 80 * this.pduExecutor.getActiveCount() / this.pduExecutor.getMaximumPoolSize() + 20 * this.workQueue.size() / this.queueCapacity;
        }
    }

    private class ResponseHandlerImpl
    implements OutboundResponseHandler {
        private ResponseHandlerImpl() {
        }

        @Override
        public void sendBindResp(String systemId, InterfaceVersion interfaceVersion, BindType bindType, int sequenceNumber) throws IOException {
            SMPPOutboundSession.this.sessionContext.bound(bindType, interfaceVersion);
            try {
                SMPPOutboundSession.this.pduSender().sendBindResp(SMPPOutboundSession.this.out, bindType.responseCommandId(), sequenceNumber, systemId, interfaceVersion);
            }
            catch (PDUStringException e) {
                log.error("Failed sending bind response", (Throwable)e);
            }
        }

        @Override
        public DataSmResult processDataSm(DataSm dataSm) throws ProcessRequestException {
            try {
                return SMPPOutboundSession.this.fireAcceptDataSm(dataSm);
            }
            catch (ProcessRequestException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = "Invalid runtime exception thrown when processing data_sm";
                log.error(msg, (Throwable)e);
                throw new ProcessRequestException(msg, 100);
            }
        }

        @Override
        public void sendDataSmResp(DataSmResult dataSmResult, int sequenceNumber) throws IOException {
            try {
                SMPPOutboundSession.this.pduSender().sendDataSmResp(SMPPOutboundSession.this.out, dataSmResult.getCommandStatus(), sequenceNumber, dataSmResult.getMessageId(), dataSmResult.getOptionalParameters());
            }
            catch (PDUStringException e) {
                log.error("Failed sending data_sm_resp", (Throwable)e);
            }
        }

        @Override
        public PendingResponse<Command> removeSentItem(int sequenceNumber) {
            return SMPPOutboundSession.this.removePendingResponse(sequenceNumber);
        }

        @Override
        public void notifyUnbonded() {
            SMPPOutboundSession.this.sessionContext.unbound();
        }

        @Override
        public void sendDeliverSmResp(int commandStatus, int sequenceNumber, String messageId) throws IOException {
            SMPPOutboundSession.this.pduSender().sendDeliverSmResp(SMPPOutboundSession.this.out, commandStatus, sequenceNumber, messageId);
        }

        @Override
        public void sendEnquireLinkResp(int sequenceNumber) throws IOException {
            SMPPOutboundSession.this.pduSender().sendEnquireLinkResp(SMPPOutboundSession.this.out, sequenceNumber);
        }

        @Override
        public void sendGenericNack(int commandStatus, int sequenceNumber) throws IOException {
            SMPPOutboundSession.this.pduSender().sendGenericNack(SMPPOutboundSession.this.out, commandStatus, sequenceNumber);
        }

        @Override
        public void sendNegativeResponse(int originalCommandId, int commandStatus, int sequenceNumber) throws IOException {
            SMPPOutboundSession.this.pduSender().sendHeader(SMPPOutboundSession.this.out, originalCommandId | Integer.MIN_VALUE, commandStatus, sequenceNumber);
        }

        @Override
        public void sendUnbindResp(int sequenceNumber) throws IOException {
            SMPPOutboundSession.this.pduSender().sendUnbindResp(SMPPOutboundSession.this.out, 0, sequenceNumber);
        }

        @Override
        public void processBind(Bind bind) {
            SMPPOutboundSession.this.bindRequestReceiver.notifyAcceptBind(bind);
        }

        @Override
        public void processEnquireLink(EnquireLink enquireLink) {
        }
    }
}

