/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.AbstractSessionContext;
import org.jsmpp.session.SMPPOutboundSession;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.state.SMPPOutboundSessionState;

public class SMPPOutboundSessionContext
extends AbstractSessionContext {
    private final SMPPOutboundSession smppSession;
    private SMPPOutboundSessionState stateProcessor = SMPPOutboundSessionState.CLOSED;
    private final ReadWriteLock stateProcessorLock = new ReentrantReadWriteLock();

    public SMPPOutboundSessionContext(SMPPOutboundSession smppSession, SessionStateListener sessionStateListener) {
        super(sessionStateListener);
        this.smppSession = smppSession;
    }

    public SMPPOutboundSessionState getStateProcessor() {
        try {
            this.stateProcessorLock.readLock().lock();
            SMPPOutboundSessionState sMPPOutboundSessionState = this.stateProcessor;
            return sMPPOutboundSessionState;
        }
        finally {
            this.stateProcessorLock.readLock().unlock();
        }
    }

    @Override
    public SessionState getSessionState() {
        try {
            this.stateProcessorLock.readLock().lock();
            SessionState sessionState = this.stateProcessor.getSessionState();
            return sessionState;
        }
        finally {
            this.stateProcessorLock.readLock().unlock();
        }
    }

    @Override
    protected void changeState(SessionState newState) {
        if (!this.stateProcessor.getSessionState().equals((Object)newState)) {
            SessionState oldState;
            try {
                this.stateProcessorLock.writeLock().lock();
                oldState = this.stateProcessor.getSessionState();
                if (newState == SessionState.OPEN) {
                    this.stateProcessor = SMPPOutboundSessionState.OPEN;
                } else if (newState == SessionState.BOUND_RX) {
                    this.stateProcessor = SMPPOutboundSessionState.BOUND_RX;
                } else if (newState == SessionState.BOUND_TX) {
                    this.stateProcessor = SMPPOutboundSessionState.BOUND_TX;
                } else if (newState == SessionState.BOUND_TRX) {
                    this.stateProcessor = SMPPOutboundSessionState.BOUND_TRX;
                } else if (newState == SessionState.UNBOUND) {
                    this.stateProcessor = SMPPOutboundSessionState.UNBOUND;
                } else if (newState == SessionState.CLOSED) {
                    this.stateProcessor = SMPPOutboundSessionState.CLOSED;
                }
            }
            finally {
                this.stateProcessorLock.writeLock().unlock();
            }
            if (oldState != null) {
                this.fireStateChanged(newState, oldState, this.smppSession);
            }
        }
    }
}

