/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jsmpp.DefaultPDUReader;
import org.jsmpp.DefaultPDUSender;
import org.jsmpp.InvalidCommandLengthException;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.PDUReader;
import org.jsmpp.PDUSender;
import org.jsmpp.PDUStringException;
import org.jsmpp.SynchronizedPDUSender;
import org.jsmpp.bean.Bind;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.BroadcastSm;
import org.jsmpp.bean.CancelBroadcastSm;
import org.jsmpp.bean.CancelSm;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.EnquireLink;
import org.jsmpp.bean.InterfaceVersion;
import org.jsmpp.bean.MessageState;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.QueryBroadcastSm;
import org.jsmpp.bean.QuerySm;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.ReplaceSm;
import org.jsmpp.bean.SubmitMulti;
import org.jsmpp.bean.SubmitSm;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.PendingResponse;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.QueueMaxException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.AbstractSession;
import org.jsmpp.session.AbstractSessionContext;
import org.jsmpp.session.AlertNotificationCommandTask;
import org.jsmpp.session.BindRequest;
import org.jsmpp.session.BindRequestReceiver;
import org.jsmpp.session.BroadcastSmResult;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.DeliverSmCommandTask;
import org.jsmpp.session.GenericMessageReceiverListener;
import org.jsmpp.session.PDUProcessServerTask;
import org.jsmpp.session.QueryBroadcastSmResult;
import org.jsmpp.session.QuerySmResult;
import org.jsmpp.session.SMPPServerSessionContext;
import org.jsmpp.session.ServerMessageReceiverListener;
import org.jsmpp.session.ServerResponseDeliveryListener;
import org.jsmpp.session.ServerResponseHandler;
import org.jsmpp.session.ServerSession;
import org.jsmpp.session.Session;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.SubmitMultiResult;
import org.jsmpp.session.SubmitSmResult;
import org.jsmpp.session.connection.Connection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPPServerSession
extends AbstractSession
implements ServerSession {
    private static final String MESSAGE_RECEIVER_LISTENER_IS_NULL = "Received {} but message receiver listener is null";
    private static final String NO_MESSAGE_RECEIVER_LISTENER_REGISTERED = "No message receiver listener registered";
    private static final Logger log = LoggerFactory.getLogger(SMPPServerSession.class);
    private final Connection conn;
    private final DataInputStream in;
    private final OutputStream out;
    private final PDUReader pduReader;
    private final SMPPServerSessionContext sessionContext = new SMPPServerSessionContext(this);
    private final ServerResponseHandler responseHandler = new ResponseHandlerImpl();
    private PDUReaderWorker pduReaderWorker;
    private ServerMessageReceiverListener messageReceiverListener;
    private ServerResponseDeliveryListener responseDeliveryListener;
    private final BindRequestReceiver bindRequestReceiver = new BindRequestReceiver(this.responseHandler);

    public SMPPServerSession(Connection conn, SessionStateListener sessionStateListener, ServerMessageReceiverListener messageReceiverListener, ServerResponseDeliveryListener responseDeliveryListener, int pduProcessorDegree, int queueCapacity) {
        this(conn, sessionStateListener, messageReceiverListener, responseDeliveryListener, pduProcessorDegree, queueCapacity, new SynchronizedPDUSender(new DefaultPDUSender()), new DefaultPDUReader());
    }

    public SMPPServerSession(Connection conn, SessionStateListener sessionStateListener, ServerMessageReceiverListener messageReceiverListener, ServerResponseDeliveryListener responseDeliveryListener, int pduProcessorDegree, int queueCapacity, PDUSender pduSender, PDUReader pduReader) {
        super(pduSender);
        this.conn = conn;
        this.messageReceiverListener = messageReceiverListener;
        this.responseDeliveryListener = responseDeliveryListener;
        this.pduReader = pduReader;
        this.in = new DataInputStream(conn.getInputStream());
        this.out = conn.getOutputStream();
        this.enquireLinkSender = new AbstractSession.EnquireLinkSender();
        this.addSessionStateListener(new BoundSessionStateListener());
        this.addSessionStateListener(sessionStateListener);
        this.setPduProcessorDegree(pduProcessorDegree);
        this.setQueueCapacity(queueCapacity);
        this.sessionContext.open();
    }

    public InetAddress getInetAddress() {
        return this.connection().getInetAddress();
    }

    public int getPort() {
        return this.connection().getPort();
    }

    public BindRequest waitForBind(long timeout) throws IllegalStateException, TimeoutException {
        SessionState currentSessionState = this.getSessionState();
        if (currentSessionState.equals((Object)SessionState.OPEN)) {
            this.pduReaderWorker = new PDUReaderWorker(this.getPduProcessorDegree(), this.getQueueCapacity());
            this.pduReaderWorker.start();
            try {
                return this.bindRequestReceiver.waitForRequest(timeout);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Invocation of waitForBind() has been made", e);
            }
            catch (TimeoutException e) {
                this.close();
                throw e;
            }
        }
        throw new IllegalStateException("waitForBind() should be invoked on OPEN state, actual state is " + (Object)((Object)currentSessionState));
    }

    @Override
    public void deliverShortMessage(String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber destAddrTon, NumberingPlanIndicator destAddrNpi, String destinationAddr, ESMClass esmClass, byte protocolId, byte priorityFlag, RegisteredDelivery registeredDelivery, DataCoding dataCoding, byte[] shortMessage, OptionalParameter ... optionalParameters) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        this.ensureReceivable("deliverShortMessage");
        DeliverSmCommandTask task = new DeliverSmCommandTask(this.pduSender(), serviceType, sourceAddrTon, sourceAddrNpi, sourceAddr, destAddrTon, destAddrNpi, destinationAddr, esmClass, protocolId, priorityFlag, registeredDelivery, dataCoding, shortMessage, optionalParameters);
        this.executeSendCommand(task, this.getTransactionTimer());
    }

    @Override
    public void alertNotification(TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber esmeAddrTon, NumberingPlanIndicator esmeAddrNpi, String esmeAddr, OptionalParameter ... optionalParameters) throws PDUException, IOException {
        this.ensureReceivable("alertNotification");
        AlertNotificationCommandTask task = new AlertNotificationCommandTask(this.pduSender(), sourceAddrTon, sourceAddrNpi, sourceAddr, esmeAddrTon, esmeAddrNpi, esmeAddr, optionalParameters);
        this.executeSendCommandWithNoResponse(task);
    }

    private SubmitSmResult fireAcceptSubmitSm(SubmitSm submitSm) throws ProcessRequestException {
        if (this.messageReceiverListener != null) {
            return this.messageReceiverListener.onAcceptSubmitSm(submitSm, this);
        }
        log.warn("Received submit_sm but MessageReceiverListener is null, returning SMPP error");
        throw new ProcessRequestException(NO_MESSAGE_RECEIVER_LISTENER_REGISTERED, 102);
    }

    private SubmitMultiResult fireAcceptSubmitMulti(SubmitMulti submitMulti) throws ProcessRequestException {
        if (this.messageReceiverListener != null) {
            return this.messageReceiverListener.onAcceptSubmitMulti(submitMulti, this);
        }
        log.warn(MESSAGE_RECEIVER_LISTENER_IS_NULL, (Object)"submit_multi");
        throw new ProcessRequestException(NO_MESSAGE_RECEIVER_LISTENER_REGISTERED, 102);
    }

    private QuerySmResult fireAcceptQuerySm(QuerySm querySm) throws ProcessRequestException {
        if (this.messageReceiverListener != null) {
            return this.messageReceiverListener.onAcceptQuerySm(querySm, this);
        }
        log.warn(MESSAGE_RECEIVER_LISTENER_IS_NULL, (Object)"query_sm");
        throw new ProcessRequestException(NO_MESSAGE_RECEIVER_LISTENER_REGISTERED, 102);
    }

    private void fireAcceptReplaceSm(ReplaceSm replaceSm) throws ProcessRequestException {
        if (this.messageReceiverListener == null) {
            log.warn(MESSAGE_RECEIVER_LISTENER_IS_NULL, (Object)"replace_sm");
            throw new ProcessRequestException(NO_MESSAGE_RECEIVER_LISTENER_REGISTERED, 102);
        }
        this.messageReceiverListener.onAcceptReplaceSm(replaceSm, this);
    }

    private void fireAcceptCancelSm(CancelSm cancelSm) throws ProcessRequestException {
        if (this.messageReceiverListener == null) {
            log.warn(MESSAGE_RECEIVER_LISTENER_IS_NULL, (Object)"cancel_sm");
            throw new ProcessRequestException(NO_MESSAGE_RECEIVER_LISTENER_REGISTERED, 102);
        }
        this.messageReceiverListener.onAcceptCancelSm(cancelSm, this);
    }

    private BroadcastSmResult fireAcceptBroadcastSm(BroadcastSm broadcastSm) throws ProcessRequestException {
        if (this.messageReceiverListener != null) {
            return this.messageReceiverListener.onAcceptBroadcastSm(broadcastSm, this);
        }
        log.warn(MESSAGE_RECEIVER_LISTENER_IS_NULL, (Object)"broadcast_sm");
        throw new ProcessRequestException(NO_MESSAGE_RECEIVER_LISTENER_REGISTERED, 102);
    }

    private void fireAcceptCancelBroadcastSm(CancelBroadcastSm cancelBroadcastSm) throws ProcessRequestException {
        if (this.messageReceiverListener == null) {
            log.warn(MESSAGE_RECEIVER_LISTENER_IS_NULL, (Object)"cancel_broadcast_sm");
            throw new ProcessRequestException(NO_MESSAGE_RECEIVER_LISTENER_REGISTERED, 102);
        }
        this.messageReceiverListener.onAcceptCancelBroadcastSm(cancelBroadcastSm, this);
    }

    private QueryBroadcastSmResult fireAcceptQueryBroadcastSm(QueryBroadcastSm queryBroadcastSm) throws ProcessRequestException {
        if (this.messageReceiverListener != null) {
            return this.messageReceiverListener.onAcceptQueryBroadcastSm(queryBroadcastSm, this);
        }
        log.warn(MESSAGE_RECEIVER_LISTENER_IS_NULL, (Object)"query_broadcast_sm");
        throw new ProcessRequestException(NO_MESSAGE_RECEIVER_LISTENER_REGISTERED, 102);
    }

    private void fireSubmitSmRespSent(SubmitSmResult submitSmResult) {
        if (this.responseDeliveryListener != null) {
            this.responseDeliveryListener.onSubmitSmRespSent(submitSmResult, this);
        }
    }

    private void fireSubmitSmRespFailed(SubmitSmResult submitSmResult, Exception cause) {
        if (this.responseDeliveryListener != null) {
            this.responseDeliveryListener.onSubmitSmRespError(submitSmResult, cause, this);
        }
    }

    private void fireSubmitMultiRespSent(SubmitMultiResult submitMultiResult) {
        if (this.responseDeliveryListener != null) {
            this.responseDeliveryListener.onSubmitMultiRespSent(submitMultiResult, this);
        }
    }

    private void fireSubmitMultiRespSentError(SubmitMultiResult submitMultiResult, Exception cause) {
        if (this.responseDeliveryListener != null) {
            this.responseDeliveryListener.onSubmitMultiRespError(submitMultiResult, cause, this);
        }
    }

    @Override
    protected Connection connection() {
        return this.conn;
    }

    @Override
    protected AbstractSessionContext sessionContext() {
        return this.sessionContext;
    }

    @Override
    protected GenericMessageReceiverListener messageReceiverListener() {
        return this.messageReceiverListener;
    }

    public ServerMessageReceiverListener getMessageReceiverListener() {
        return this.messageReceiverListener;
    }

    public void setMessageReceiverListener(ServerMessageReceiverListener messageReceiverListener) {
        this.messageReceiverListener = messageReceiverListener;
    }

    public void setResponseDeliveryListener(ServerResponseDeliveryListener responseDeliveryListener) {
        this.responseDeliveryListener = responseDeliveryListener;
    }

    public int getCongestionRatio() {
        return this.pduReaderWorker.getCongestionRatio();
    }

    private class BoundSessionStateListener
    implements SessionStateListener {
        private BoundSessionStateListener() {
        }

        @Override
        public void onStateChange(SessionState newState, SessionState oldState, Session source) {
            if (newState.equals((Object)SessionState.OPEN)) {
                try {
                    SMPPServerSession.this.connection().setSoTimeout(source.getEnquireLinkTimer());
                }
                catch (IOException e) {
                    log.error("Failed setting so_timeout for session timer", (Throwable)e);
                }
                SMPPServerSession.this.enquireLinkSender.start();
            }
        }
    }

    private class PDUReaderWorker
    extends Thread {
        private ThreadPoolExecutor pduExecutor;
        private LinkedBlockingQueue<Runnable> workQueue;
        private int queueCapacity;
        private final Runnable onIOExceptionTask;

        private PDUReaderWorker(int pduProcessorDegree, int queueCapacity) {
            super("PDUReaderWorker-" + SMPPServerSession.this.getSessionId());
            this.onIOExceptionTask = () -> SMPPServerSession.this.close();
            this.queueCapacity = queueCapacity;
            this.workQueue = new LinkedBlockingQueue(queueCapacity);
            this.pduExecutor = new ThreadPoolExecutor(pduProcessorDegree, pduProcessorDegree, 0L, TimeUnit.MILLISECONDS, this.workQueue, (runnable, executor) -> {
                log.info("Receiving queue is full, please increasing queue capacity, and/or let other side obey the window size");
                Command pduHeader = ((PDUProcessServerTask)runnable).getPduHeader();
                if ((pduHeader.getCommandId() & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                    try {
                        boolean success = executor.getQueue().offer(runnable, 60000L, TimeUnit.MILLISECONDS);
                        if (!success) {
                            log.warn("Offer to queue failed for {}", (Object)pduHeader);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    throw new QueueMaxException("Receiving queue capacity " + queueCapacity + " exceeded");
                }
            });
        }

        @Override
        public void run() {
            while (SMPPServerSession.this.isReadPdu()) {
                this.readPDU();
            }
            SMPPServerSession.this.close();
            this.pduExecutor.shutdown();
            try {
                this.pduExecutor.awaitTermination(SMPPServerSession.this.getTransactionTimer(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for PDU executor pool to finish");
                Thread.currentThread().interrupt();
            }
            log.debug("{} stopped", (Object)this.getName());
        }

        private void readPDU() {
            Command pduHeader = null;
            try {
                pduHeader = SMPPServerSession.this.pduReader.readPDUHeader(SMPPServerSession.this.in);
                byte[] pdu = SMPPServerSession.this.pduReader.readPDU(SMPPServerSession.this.in, pduHeader);
                PDUProcessServerTask task = new PDUProcessServerTask(pduHeader, pdu, SMPPServerSession.this.sessionContext.getStateProcessor(), SMPPServerSession.this.sessionContext, SMPPServerSession.this.responseHandler, this.onIOExceptionTask);
                this.pduExecutor.execute(task);
            }
            catch (QueueMaxException e) {
                log.info("Notify other side to throttle: {} ({} threads active)", (Object)e.getMessage(), (Object)this.pduExecutor.getActiveCount());
                try {
                    SMPPServerSession.this.responseHandler.sendNegativeResponse(pduHeader.getCommandId(), 88, pduHeader.getSequenceNumber());
                }
                catch (IOException ioe) {
                    log.warn("Failed sending negative response: {}", (Object)ioe.getMessage());
                    SMPPServerSession.this.close();
                }
            }
            catch (InvalidCommandLengthException e) {
                log.warn("Received invalid command length: {}", (Object)e.getMessage());
                try {
                    SMPPServerSession.this.pduSender().sendGenericNack(SMPPServerSession.this.out, 2, 0);
                }
                catch (IOException ee) {
                    log.warn("Failed sending generic_nack", (Throwable)ee);
                }
                SMPPServerSession.this.unbindAndClose();
            }
            catch (SocketTimeoutException e) {
                this.notifyNoActivity();
            }
            catch (EOFException e) {
                if (SMPPServerSession.this.sessionContext.getSessionState() == SessionState.UNBOUND) {
                    log.info("Unbound session {} socket closed", (Object)SMPPServerSession.this.getSessionId());
                } else {
                    log.warn("Session {} socket closed unexpected", (Object)SMPPServerSession.this.getSessionId());
                }
                SMPPServerSession.this.close();
            }
            catch (IOException e) {
                log.info("Reading PDU session {} in state {}: {}", new Object[]{SMPPServerSession.this.getSessionId(), SMPPServerSession.this.getSessionState(), e.getMessage()});
                SMPPServerSession.this.close();
            }
            catch (RuntimeException e) {
                log.warn("Runtime error while reading", (Throwable)e);
                SMPPServerSession.this.close();
            }
        }

        private void notifyNoActivity() {
            log.debug("No activity notified, sending enquire_link");
            SMPPServerSession.this.enquireLinkSender.enquireLink();
        }

        public int getCongestionRatio() {
            return 80 * this.pduExecutor.getActiveCount() / this.pduExecutor.getMaximumPoolSize() + 20 * this.workQueue.size() / this.queueCapacity;
        }
    }

    private class ResponseHandlerImpl
    implements ServerResponseHandler {
        private ResponseHandlerImpl() {
        }

        @Override
        public PendingResponse<Command> removeSentItem(int sequenceNumber) {
            return SMPPServerSession.this.removePendingResponse(sequenceNumber);
        }

        @Override
        public void notifyUnbonded() {
            SMPPServerSession.this.sessionContext.unbound();
        }

        @Override
        public void sendEnquireLinkResp(int sequenceNumber) throws IOException {
            SMPPServerSession.this.pduSender().sendEnquireLinkResp(SMPPServerSession.this.out, sequenceNumber);
        }

        @Override
        public void sendGenericNack(int commandStatus, int sequenceNumber) throws IOException {
            SMPPServerSession.this.pduSender().sendGenericNack(SMPPServerSession.this.out, commandStatus, sequenceNumber);
        }

        @Override
        public void sendNegativeResponse(int originalCommandId, int commandStatus, int sequenceNumber) throws IOException {
            SMPPServerSession.this.pduSender().sendHeader(SMPPServerSession.this.out, originalCommandId | Integer.MIN_VALUE, commandStatus, sequenceNumber);
        }

        @Override
        public void sendUnbindResp(int sequenceNumber) throws IOException {
            SMPPServerSession.this.pduSender().sendUnbindResp(SMPPServerSession.this.out, 0, sequenceNumber);
        }

        @Override
        public void sendBindResp(String systemId, InterfaceVersion interfaceVersion, BindType bindType, int sequenceNumber) throws IOException {
            SMPPServerSession.this.sessionContext.bound(bindType, interfaceVersion);
            try {
                SMPPServerSession.this.pduSender().sendBindResp(SMPPServerSession.this.out, bindType.responseCommandId(), sequenceNumber, systemId, interfaceVersion);
            }
            catch (PDUStringException e) {
                log.error("Failed sending bind response", (Throwable)e);
            }
        }

        @Override
        public void processBind(Bind bind) {
            SMPPServerSession.this.bindRequestReceiver.notifyAcceptBind(bind);
        }

        @Override
        public SubmitSmResult processSubmitSm(SubmitSm submitSm) throws ProcessRequestException {
            try {
                SubmitSmResult submitSmResult = SMPPServerSession.this.fireAcceptSubmitSm(submitSm);
                if (submitSmResult == null) {
                    String msg = "Invalid submitSmResult, shouldn't null value. " + ServerMessageReceiverListener.class + "#onAcceptSubmitSm(SubmitSm) return null value";
                    log.error(msg);
                    throw new ProcessRequestException(msg, 102);
                }
                return submitSmResult;
            }
            catch (ProcessRequestException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = "Invalid runtime exception thrown when processing submit_sm";
                log.error(msg, (Throwable)e);
                throw new ProcessRequestException(msg, 8);
            }
        }

        @Override
        public void sendSubmitSmResponse(SubmitSmResult submitSmResult, int sequenceNumber) throws IOException {
            try {
                SMPPServerSession.this.pduSender().sendSubmitSmResp(SMPPServerSession.this.out, sequenceNumber, submitSmResult.getMessageId(), submitSmResult.getOptionalParameters());
                SMPPServerSession.this.fireSubmitSmRespSent(submitSmResult);
            }
            catch (PDUStringException e) {
                log.error("Failed sending submit_sm_resp", (Throwable)e);
                SMPPServerSession.this.fireSubmitSmRespFailed(submitSmResult, e);
            }
            catch (IOException | RuntimeException e) {
                SMPPServerSession.this.fireSubmitSmRespFailed(submitSmResult, e);
                throw e;
            }
        }

        @Override
        public SubmitMultiResult processSubmitMulti(SubmitMulti submitMulti) throws ProcessRequestException {
            try {
                return SMPPServerSession.this.fireAcceptSubmitMulti(submitMulti);
            }
            catch (ProcessRequestException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = "Invalid runtime exception thrown when processing SubmitMultiSm";
                log.error(msg, (Throwable)e);
                throw new ProcessRequestException(msg, 8);
            }
        }

        @Override
        public void sendSubmitMultiResponse(SubmitMultiResult submitMultiResult, int sequenceNumber) throws IOException {
            try {
                SMPPServerSession.this.pduSender().sendSubmitMultiResp(SMPPServerSession.this.out, sequenceNumber, submitMultiResult.getMessageId(), submitMultiResult.getUnsuccessDeliveries());
                SMPPServerSession.this.fireSubmitMultiRespSent(submitMultiResult);
            }
            catch (PDUStringException e) {
                log.error("Failed sending submit_multi_resp", (Throwable)e);
                SMPPServerSession.this.fireSubmitMultiRespSentError(submitMultiResult, e);
            }
            catch (IOException | RuntimeException e) {
                SMPPServerSession.this.fireSubmitMultiRespSentError(submitMultiResult, e);
                throw e;
            }
        }

        @Override
        public QuerySmResult processQuerySm(QuerySm querySm) throws ProcessRequestException {
            try {
                return SMPPServerSession.this.fireAcceptQuerySm(querySm);
            }
            catch (ProcessRequestException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = "Invalid runtime exception thrown when processing query_sm";
                log.error(msg, (Throwable)e);
                throw new ProcessRequestException(msg, 8);
            }
        }

        @Override
        public void sendQuerySmResp(String messageId, String finalDate, MessageState messageState, byte errorCode, int sequenceNumber) throws IOException {
            try {
                SMPPServerSession.this.pduSender().sendQuerySmResp(SMPPServerSession.this.out, sequenceNumber, messageId, finalDate, messageState, errorCode);
            }
            catch (PDUStringException e) {
                log.error("Failed sending query_sm_resp", (Throwable)e);
            }
        }

        @Override
        public DataSmResult processDataSm(DataSm dataSm) throws ProcessRequestException {
            try {
                return SMPPServerSession.this.fireAcceptDataSm(dataSm);
            }
            catch (ProcessRequestException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = "Invalid runtime exception thrown when processing data_sm";
                log.error(msg, (Throwable)e);
                throw new ProcessRequestException(msg, 8);
            }
        }

        @Override
        public void sendDataSmResp(DataSmResult dataSmResult, int sequenceNumber) throws IOException {
            try {
                SMPPServerSession.this.pduSender().sendDataSmResp(SMPPServerSession.this.out, dataSmResult.getCommandStatus(), sequenceNumber, dataSmResult.getMessageId(), dataSmResult.getOptionalParameters());
            }
            catch (PDUStringException e) {
                log.error("Failed sending data_sm_resp", (Throwable)e);
            }
        }

        @Override
        public void processCancelSm(CancelSm cancelSm) throws ProcessRequestException {
            try {
                SMPPServerSession.this.fireAcceptCancelSm(cancelSm);
            }
            catch (ProcessRequestException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = "Invalid runtime exception thrown when processing cancel_sm";
                log.error(msg, (Throwable)e);
                throw new ProcessRequestException(msg, 8);
            }
        }

        @Override
        public void sendCancelSmResp(int sequenceNumber) throws IOException {
            SMPPServerSession.this.pduSender().sendCancelSmResp(SMPPServerSession.this.out, sequenceNumber);
        }

        @Override
        public void processReplaceSm(ReplaceSm replaceSm) throws ProcessRequestException {
            try {
                SMPPServerSession.this.fireAcceptReplaceSm(replaceSm);
            }
            catch (ProcessRequestException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = "Invalid runtime exception thrown when processing replace_sm";
                log.error(msg, (Throwable)e);
                throw new ProcessRequestException(msg, 8);
            }
        }

        @Override
        public void sendReplaceSmResp(int sequenceNumber) throws IOException {
            SMPPServerSession.this.pduSender().sendReplaceSmResp(SMPPServerSession.this.out, sequenceNumber);
        }

        @Override
        public BroadcastSmResult processBroadcastSm(BroadcastSm broadcastSm) throws ProcessRequestException {
            try {
                BroadcastSmResult broadcastSmResult = SMPPServerSession.this.fireAcceptBroadcastSm(broadcastSm);
                if (broadcastSmResult == null) {
                    String msg = "Invalid broadcastSmResult, shouldn't null value. " + ServerMessageReceiverListener.class + "#onAcceptBroadcastSm(broadcastSm) return null value";
                    log.error(msg);
                    throw new ProcessRequestException(msg, 102);
                }
                return broadcastSmResult;
            }
            catch (ProcessRequestException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = "Invalid runtime exception thrown when processing broadcast_sm";
                log.error(msg, (Throwable)e);
                throw new ProcessRequestException(msg, 8);
            }
        }

        @Override
        public void sendBroadcastSmResp(BroadcastSmResult broadcastSmResult, int sequenceNumber) throws IOException {
            try {
                SMPPServerSession.this.pduSender().sendBroadcastSmResp(SMPPServerSession.this.out, sequenceNumber, broadcastSmResult.getMessageId(), broadcastSmResult.getOptionalParameters());
            }
            catch (PDUStringException e) {
                log.error("Failed sending broadcast_sm_resp", (Throwable)e);
            }
        }

        @Override
        public void processCancelBroadcastSm(CancelBroadcastSm cancelBroadcastSm) throws ProcessRequestException {
            try {
                SMPPServerSession.this.fireAcceptCancelBroadcastSm(cancelBroadcastSm);
            }
            catch (ProcessRequestException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = "Invalid runtime exception thrown when processing cancel_broadcast_sm";
                log.error(msg, (Throwable)e);
                throw new ProcessRequestException(msg, 8);
            }
        }

        @Override
        public void sendCancelBroadcastSmResp(int sequenceNumber) throws IOException {
            SMPPServerSession.this.pduSender().sendCancelBroadcastSmResp(SMPPServerSession.this.out, sequenceNumber);
        }

        @Override
        public QueryBroadcastSmResult processQueryBroadcastSm(QueryBroadcastSm queryBroadcastSm) throws ProcessRequestException {
            try {
                QueryBroadcastSmResult queryBroadcastSmResult = SMPPServerSession.this.fireAcceptQueryBroadcastSm(queryBroadcastSm);
                if (queryBroadcastSmResult == null) {
                    String msg = "Invalid queryBroadcastSmResult, shouldn't null value. " + ServerMessageReceiverListener.class + "#onAcceptQueryBroadcastSm(broadcastSm) return null value";
                    log.error(msg);
                    throw new ProcessRequestException(msg, 102);
                }
                return queryBroadcastSmResult;
            }
            catch (ProcessRequestException e) {
                throw e;
            }
            catch (Exception e) {
                String msg = "Invalid runtime exception thrown when processing query_broadcast_sm";
                log.error(msg, (Throwable)e);
                throw new ProcessRequestException(msg, 8);
            }
        }

        @Override
        public void sendQueryBroadcastSmResp(QueryBroadcastSmResult queryBroadcastSmResult, int sequenceNumber) throws IOException {
            try {
                SMPPServerSession.this.pduSender().sendQueryBroadcastSmResp(SMPPServerSession.this.out, sequenceNumber, queryBroadcastSmResult.getMessageId(), queryBroadcastSmResult.getOptionalParameters());
            }
            catch (PDUStringException e) {
                log.error("Sending failed query_broadcast_sm_resp", (Throwable)e);
            }
        }

        @Override
        public void processEnquireLink(EnquireLink enquireLink) {
            try {
                SMPPServerSession.this.fireAcceptEnquirelink(enquireLink);
            }
            catch (Exception e) {
                log.error("Invalid runtime exception thrown when processing enquire_link", (Throwable)e);
            }
        }
    }
}

