/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.io.IOException;
import org.jsmpp.session.SMPPServerSession;
import org.jsmpp.session.ServerMessageReceiverListener;
import org.jsmpp.session.ServerResponseDeliveryListener;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.connection.Connection;
import org.jsmpp.session.connection.ServerConnection;
import org.jsmpp.session.connection.ServerConnectionFactory;
import org.jsmpp.session.connection.socket.ServerSocketConnectionFactory;

public class SMPPServerSessionListener
implements AutoCloseable {
    private final int port;
    private final ServerConnection serverConn;
    private int initiationTimer = 5000;
    private int pduProcessorDegree = 3;
    private int queueCapacity = 100;
    private SessionStateListener sessionStateListener;
    private ServerMessageReceiverListener messageReceiverListener;
    private ServerResponseDeliveryListener responseDeliveryListener;

    public SMPPServerSessionListener(int port) throws IOException {
        this(port, new ServerSocketConnectionFactory());
    }

    public SMPPServerSessionListener(int port, ServerConnectionFactory serverConnFactory) throws IOException {
        this.port = port;
        this.serverConn = serverConnFactory.listen(port);
    }

    public SMPPServerSessionListener(int port, int timeout, ServerConnectionFactory serverConnFactory) throws IOException {
        this.port = port;
        this.serverConn = serverConnFactory.listen(port, timeout);
    }

    public SMPPServerSessionListener(int port, int timeout, int backlog, ServerConnectionFactory serverConnFactory) throws IOException {
        this.port = port;
        this.serverConn = serverConnFactory.listen(port, timeout, backlog);
    }

    public int getTimeout() throws IOException {
        return this.serverConn.getSoTimeout();
    }

    public void setTimeout(int timeout) throws IOException {
        this.serverConn.setSoTimeout(timeout);
    }

    public void setPduProcessorDegree(int pduProcessorDegree) {
        this.pduProcessorDegree = pduProcessorDegree;
    }

    public int getPduProcessorDegree() {
        return this.pduProcessorDegree;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public int getPort() {
        return this.port;
    }

    public int getInitiationTimer() {
        return this.initiationTimer;
    }

    public void setInitiationTimer(int initiationTimer) {
        this.initiationTimer = initiationTimer;
    }

    public SessionStateListener getSessionStateListener() {
        return this.sessionStateListener;
    }

    public void setSessionStateListener(SessionStateListener sessionStateListener) {
        this.sessionStateListener = sessionStateListener;
    }

    public ServerMessageReceiverListener getMessageReceiverListener() {
        return this.messageReceiverListener;
    }

    public void setMessageReceiverListener(ServerMessageReceiverListener messageReceiverListener) {
        this.messageReceiverListener = messageReceiverListener;
    }

    public void setResponseDeliveryListener(ServerResponseDeliveryListener responseDeliveryListener) {
        this.responseDeliveryListener = responseDeliveryListener;
    }

    public SMPPServerSession accept() throws IOException {
        Connection conn = this.serverConn.accept();
        conn.setSoTimeout(this.initiationTimer);
        return new SMPPServerSession(conn, this.sessionStateListener, this.messageReceiverListener, this.responseDeliveryListener, this.pduProcessorDegree, this.queueCapacity);
    }

    @Override
    public void close() throws IOException {
        this.serverConn.close();
    }
}

