/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session.state;

import java.io.IOException;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.BroadcastSmResp;
import org.jsmpp.bean.CancelBroadcastSmResp;
import org.jsmpp.bean.CancelSmResp;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.InterfaceVersion;
import org.jsmpp.bean.QueryBroadcastSmResp;
import org.jsmpp.bean.QuerySmResp;
import org.jsmpp.bean.ReplaceSmResp;
import org.jsmpp.bean.SubmitMultiResp;
import org.jsmpp.bean.SubmitSmResp;
import org.jsmpp.extra.PendingResponse;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.ResponseHandler;
import org.jsmpp.session.state.SMPPSessionBound;
import org.jsmpp.session.state.SMPPSessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SMPPSessionBoundTX
extends SMPPSessionBound
implements SMPPSessionState {
    private static final Logger log = LoggerFactory.getLogger(SMPPSessionBoundTX.class);
    private static final String NO_REQUEST_FOR_SEQUENCE_NUMBER_FOUND = "No request for sequence_number {} found";

    SMPPSessionBoundTX() {
    }

    @Override
    public SessionState getSessionState() {
        return SessionState.BOUND_TX;
    }

    @Override
    public void processSubmitSmResp(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(pduHeader.getSequenceNumber());
        if (pendingResp != null) {
            try {
                SubmitSmResp resp = pduDecomposer.submitSmResp(pdu);
                pendingResp.done(resp);
            }
            catch (PDUStringException e) {
                log.error("Failed decomposing submit_sm_resp", (Throwable)e);
                responseHandler.sendGenericNack(e.getErrorCode(), pduHeader.getSequenceNumber());
            }
        } else {
            log.warn(NO_REQUEST_FOR_SEQUENCE_NUMBER_FOUND, (Object)pduHeader.getSequenceNumber());
        }
    }

    @Override
    public void processSubmitMultiResp(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(pduHeader.getSequenceNumber());
        if (pendingResp != null) {
            try {
                SubmitMultiResp resp = pduDecomposer.submitMultiResp(pdu);
                pendingResp.done(resp);
            }
            catch (PDUStringException e) {
                log.error("Failed decomposing submit_multi_resp", (Throwable)e);
                responseHandler.sendGenericNack(e.getErrorCode(), pduHeader.getSequenceNumber());
            }
        } else {
            log.warn(NO_REQUEST_FOR_SEQUENCE_NUMBER_FOUND, (Object)pduHeader.getSequenceNumber());
        }
    }

    @Override
    public void processQuerySmResp(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(pduHeader.getSequenceNumber());
        if (pendingResp != null) {
            try {
                QuerySmResp resp = pduDecomposer.querySmResp(pdu);
                pendingResp.done(resp);
            }
            catch (PDUStringException e) {
                log.error("Failed decomposing query_sm_resp", (Throwable)e);
                responseHandler.sendGenericNack(e.getErrorCode(), pduHeader.getSequenceNumber());
            }
        } else {
            log.warn(NO_REQUEST_FOR_SEQUENCE_NUMBER_FOUND, (Object)pduHeader.getSequenceNumber());
            responseHandler.sendGenericNack(99, pduHeader.getSequenceNumber());
        }
    }

    @Override
    public void processCancelSmResp(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(pduHeader.getSequenceNumber());
        if (pendingResp != null) {
            CancelSmResp resp = pduDecomposer.cancelSmResp(pdu);
            pendingResp.done(resp);
        } else {
            log.warn(NO_REQUEST_FOR_SEQUENCE_NUMBER_FOUND, (Object)pduHeader.getSequenceNumber());
        }
    }

    @Override
    public void processReplaceSmResp(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(pduHeader.getSequenceNumber());
        if (pendingResp != null) {
            ReplaceSmResp resp = pduDecomposer.replaceSmResp(pdu);
            pendingResp.done(resp);
        } else {
            log.warn(NO_REQUEST_FOR_SEQUENCE_NUMBER_FOUND, (Object)pduHeader.getSequenceNumber());
        }
    }

    @Override
    public void processDeliverSm(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        if (this.interfaceVersion == InterfaceVersion.IF_33) {
            SMPPSessionBoundTX.processDeliverSm0(pduHeader, pdu, responseHandler);
            return;
        }
        responseHandler.sendNegativeResponse(pduHeader.getCommandId(), 4, pduHeader.getSequenceNumber());
    }

    @Override
    public void processAlertNotification(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) {
        log.error("Receiving alert_notification while on invalid bound state (transmitter)");
    }

    @Override
    public void processBroadcastSmResp(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(pduHeader.getSequenceNumber());
        if (pendingResp != null) {
            try {
                BroadcastSmResp resp = pduDecomposer.broadcastSmResp(pdu);
                pendingResp.done(resp);
            }
            catch (PDUStringException e) {
                log.error("Failed decomposing broadcast_sm_resp", (Throwable)e);
                responseHandler.sendGenericNack(e.getErrorCode(), pduHeader.getSequenceNumber());
            }
        } else {
            log.warn(NO_REQUEST_FOR_SEQUENCE_NUMBER_FOUND, (Object)pduHeader.getSequenceNumber());
        }
    }

    @Override
    public void processCancelBroadcastSmResp(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(pduHeader.getSequenceNumber());
        if (pendingResp != null) {
            try {
                CancelBroadcastSmResp resp = pduDecomposer.cancelBroadcastSmResp(pdu);
                pendingResp.done(resp);
            }
            catch (PDUStringException e) {
                log.error("Failed decomposing cancel_broadcast_sm_resp", (Throwable)e);
                responseHandler.sendGenericNack(e.getErrorCode(), pduHeader.getSequenceNumber());
            }
        } else {
            log.warn(NO_REQUEST_FOR_SEQUENCE_NUMBER_FOUND, (Object)pduHeader.getSequenceNumber());
        }
    }

    @Override
    public void processQueryBroadcastSmResp(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        PendingResponse<Command> pendingResp = responseHandler.removeSentItem(pduHeader.getSequenceNumber());
        if (pendingResp != null) {
            try {
                QueryBroadcastSmResp resp = pduDecomposer.queryBroadcastSmResp(pdu);
                pendingResp.done(resp);
            }
            catch (PDUStringException e) {
                log.error("Failed decomposing query_broadcast_sm_resp", (Throwable)e);
                responseHandler.sendGenericNack(e.getErrorCode(), pduHeader.getSequenceNumber());
            }
        } else {
            log.warn(NO_REQUEST_FOR_SEQUENCE_NUMBER_FOUND, (Object)pduHeader.getSequenceNumber());
        }
    }
}

