/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.net.URI;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="smpp,smpps")
public class SmppComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private SmppConfiguration configuration;

    public SmppComponent() {
    }

    public SmppComponent(SmppConfiguration configuration) {
        this();
        this.configuration = configuration;
    }

    public SmppComponent(CamelContext context) {
        super(context);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map parameters) throws Exception {
        if (this.configuration == null) {
            this.configuration = new SmppConfiguration();
        }
        SmppConfiguration config = this.configuration.copy();
        config.configureFromURI(new URI(uri));
        SmppEndpoint answer = new SmppEndpoint(uri, this, config);
        this.setProperties(answer, (Map<String, Object>)parameters);
        return answer;
    }

    protected Endpoint createEndpoint(SmppConfiguration config) {
        return this.createEndpoint(null, config);
    }

    protected Endpoint createEndpoint(String uri, SmppConfiguration config) {
        return new SmppEndpoint(uri, this, config);
    }

    public SmppConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SmppConfiguration configuration) {
        this.configuration = configuration;
    }
}

