/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.smpp.SmppBinding;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppConstants;
import org.apache.camel.component.smpp.SmppConsumer;
import org.apache.camel.component.smpp.SmppProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliverSm;

@UriEndpoint(firstVersion="2.2.0", scheme="smpp,smpps", title="SMPP", syntax="smpp:host:port", category={Category.MOBILE}, lenientProperties=true, headersClass=SmppConstants.class)
public class SmppEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    private SmppBinding binding;
    @UriParam
    private SmppConfiguration configuration;

    public SmppEndpoint(String endpointUri, Component component, SmppConfiguration configuration) {
        super(endpointUri, component);
        this.configuration = configuration;
    }

    @Override
    public String getServiceUrl() {
        return this.configuration.getHost() + ":" + this.configuration.getPort();
    }

    @Override
    public String getServiceProtocol() {
        return "smpp";
    }

    @Override
    protected String createEndpointUri() {
        return this.getConnectionString();
    }

    @Override
    public boolean isLenientProperties() {
        return true;
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        SmppConsumer answer = new SmppConsumer(this, this.configuration, processor);
        this.configureConsumer(answer);
        return answer;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new SmppProducer(this, this.configuration);
    }

    public Exchange createOnAcceptDeliverSmExchange(DeliverSm deliverSm) throws Exception {
        return this.createOnAcceptDeliverSmExchange(this.getExchangePattern(), deliverSm);
    }

    public Exchange createOnAcceptDeliverSmExchange(ExchangePattern exchangePattern, DeliverSm deliverSm) throws Exception {
        Exchange exchange = this.createExchange(exchangePattern);
        exchange.setProperty("CamelBinding", (Object)this.getBinding());
        exchange.setIn(this.getBinding().createSmppMessage(this.getCamelContext(), deliverSm));
        return exchange;
    }

    public Exchange createOnAcceptDataSm(DataSm dataSm, String smppMessageId) {
        return this.createOnAcceptDataSm(this.getExchangePattern(), dataSm, smppMessageId);
    }

    public Exchange createOnAcceptDataSm(ExchangePattern exchangePattern, DataSm dataSm, String smppMessageId) {
        Exchange exchange = this.createExchange(exchangePattern);
        exchange.setProperty("CamelBinding", (Object)this.getBinding());
        exchange.setIn(this.getBinding().createSmppMessage(this.getCamelContext(), dataSm, smppMessageId));
        return exchange;
    }

    public String getConnectionString() {
        return (this.configuration.isUsingSSL() ? "smpps://" : "smpp://") + (String)(this.getConfiguration().getSystemId() != null ? this.getConfiguration().getSystemId() + "@" : "") + this.getConfiguration().getHost() + ":" + this.getConfiguration().getPort();
    }

    public SmppConfiguration getConfiguration() {
        return this.configuration;
    }

    public SmppBinding getBinding() {
        if (this.binding == null) {
            this.binding = new SmppBinding(this.getConfiguration());
        }
        return this.binding;
    }

    public void setBinding(SmppBinding binding) {
        this.binding = binding;
    }
}

